// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model



/**
 * CreateTaskRequest
 */
public class CreateTaskRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to monitor and log events in the task.
     */
    public val cloudWatchLogGroupArn: kotlin.String? = builder.cloudWatchLogGroupArn
    /**
     * The Amazon Resource Name (ARN) of an Amazon Web Services storage resource's location.
     */
    public val destinationLocationArn: kotlin.String? = builder.destinationLocationArn
    /**
     * Specifies a list of filter rules that exclude specific data during your transfer. For more information and examples, see [Filtering data transferred by DataSync](https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html).
     */
    public val excludes: List<FilterRule>? = builder.excludes
    /**
     * Specifies a list of filter rules that include specific data during your transfer. For more information and examples, see [Filtering data transferred by DataSync](https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html).
     */
    public val includes: List<FilterRule>? = builder.includes
    /**
     * The name of a task. This value is a text reference that is used to identify the task in the console.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Specifies the configuration options for a task. Some options include preserving file or object metadata and verifying data integrity.
     *
     * You can also override these options before starting an individual run of a task (also known as a *task execution*). For more information, see [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html).
     */
    public val options: aws.sdk.kotlin.services.datasync.model.Options? = builder.options
    /**
     * Specifies a schedule used to periodically transfer files from a source to a destination location. The schedule should be specified in UTC time. For more information, see [Scheduling your task](https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html).
     */
    public val schedule: aws.sdk.kotlin.services.datasync.model.TaskSchedule? = builder.schedule
    /**
     * The Amazon Resource Name (ARN) of the source location for the task.
     */
    public val sourceLocationArn: kotlin.String? = builder.sourceLocationArn
    /**
     * Specifies the tags that you want to apply to the Amazon Resource Name (ARN) representing the task.
     *
     * *Tags* are key-value pairs that help you manage, filter, and search for your DataSync resources.
     */
    public val tags: List<TagListEntry>? = builder.tags
    /**
     * Specifies how you want to configure a task report, which provides detailed information about for your DataSync transfer.
     */
    public val taskReportConfig: aws.sdk.kotlin.services.datasync.model.TaskReportConfig? = builder.taskReportConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.CreateTaskRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTaskRequest(")
        append("cloudWatchLogGroupArn=$cloudWatchLogGroupArn,")
        append("destinationLocationArn=$destinationLocationArn,")
        append("excludes=$excludes,")
        append("includes=$includes,")
        append("name=$name,")
        append("options=$options,")
        append("schedule=$schedule,")
        append("sourceLocationArn=$sourceLocationArn,")
        append("tags=$tags,")
        append("taskReportConfig=$taskReportConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchLogGroupArn?.hashCode() ?: 0
        result = 31 * result + (destinationLocationArn?.hashCode() ?: 0)
        result = 31 * result + (excludes?.hashCode() ?: 0)
        result = 31 * result + (includes?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (options?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (sourceLocationArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (taskReportConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateTaskRequest

        if (cloudWatchLogGroupArn != other.cloudWatchLogGroupArn) return false
        if (destinationLocationArn != other.destinationLocationArn) return false
        if (excludes != other.excludes) return false
        if (includes != other.includes) return false
        if (name != other.name) return false
        if (options != other.options) return false
        if (schedule != other.schedule) return false
        if (sourceLocationArn != other.sourceLocationArn) return false
        if (tags != other.tags) return false
        if (taskReportConfig != other.taskReportConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.CreateTaskRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to monitor and log events in the task.
         */
        public var cloudWatchLogGroupArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of an Amazon Web Services storage resource's location.
         */
        public var destinationLocationArn: kotlin.String? = null
        /**
         * Specifies a list of filter rules that exclude specific data during your transfer. For more information and examples, see [Filtering data transferred by DataSync](https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html).
         */
        public var excludes: List<FilterRule>? = null
        /**
         * Specifies a list of filter rules that include specific data during your transfer. For more information and examples, see [Filtering data transferred by DataSync](https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html).
         */
        public var includes: List<FilterRule>? = null
        /**
         * The name of a task. This value is a text reference that is used to identify the task in the console.
         */
        public var name: kotlin.String? = null
        /**
         * Specifies the configuration options for a task. Some options include preserving file or object metadata and verifying data integrity.
         *
         * You can also override these options before starting an individual run of a task (also known as a *task execution*). For more information, see [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html).
         */
        public var options: aws.sdk.kotlin.services.datasync.model.Options? = null
        /**
         * Specifies a schedule used to periodically transfer files from a source to a destination location. The schedule should be specified in UTC time. For more information, see [Scheduling your task](https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html).
         */
        public var schedule: aws.sdk.kotlin.services.datasync.model.TaskSchedule? = null
        /**
         * The Amazon Resource Name (ARN) of the source location for the task.
         */
        public var sourceLocationArn: kotlin.String? = null
        /**
         * Specifies the tags that you want to apply to the Amazon Resource Name (ARN) representing the task.
         *
         * *Tags* are key-value pairs that help you manage, filter, and search for your DataSync resources.
         */
        public var tags: List<TagListEntry>? = null
        /**
         * Specifies how you want to configure a task report, which provides detailed information about for your DataSync transfer.
         */
        public var taskReportConfig: aws.sdk.kotlin.services.datasync.model.TaskReportConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.CreateTaskRequest) : this() {
            this.cloudWatchLogGroupArn = x.cloudWatchLogGroupArn
            this.destinationLocationArn = x.destinationLocationArn
            this.excludes = x.excludes
            this.includes = x.includes
            this.name = x.name
            this.options = x.options
            this.schedule = x.schedule
            this.sourceLocationArn = x.sourceLocationArn
            this.tags = x.tags
            this.taskReportConfig = x.taskReportConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.CreateTaskRequest = CreateTaskRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.Options] inside the given [block]
         */
        public fun options(block: aws.sdk.kotlin.services.datasync.model.Options.Builder.() -> kotlin.Unit) {
            this.options = aws.sdk.kotlin.services.datasync.model.Options.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.TaskSchedule] inside the given [block]
         */
        public fun schedule(block: aws.sdk.kotlin.services.datasync.model.TaskSchedule.Builder.() -> kotlin.Unit) {
            this.schedule = aws.sdk.kotlin.services.datasync.model.TaskSchedule.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.TaskReportConfig] inside the given [block]
         */
        public fun taskReportConfig(block: aws.sdk.kotlin.services.datasync.model.TaskReportConfig.Builder.() -> kotlin.Unit) {
            this.taskReportConfig = aws.sdk.kotlin.services.datasync.model.TaskReportConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
