// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model



/**
 * CreateLocationNfsRequest
 */
public class CreateLocationNfsRequest private constructor(builder: Builder) {
    /**
     * Specifies the options that DataSync can use to mount your NFS file server.
     */
    public val mountOptions: aws.sdk.kotlin.services.datasync.model.NfsMountOptions? = builder.mountOptions
    /**
     * Specifies the Amazon Resource Name (ARN) of the DataSync agent that want to connect to your NFS file server.
     *
     * You can specify more than one agent. For more information, see [Using multiple agents for transfers](https://docs.aws.amazon.com/datasync/latest/userguide/multiple-agents.html).
     */
    public val onPremConfig: aws.sdk.kotlin.services.datasync.model.OnPremConfig? = builder.onPremConfig
    /**
     * Specifies the Domain Name System (DNS) name or IP version 4 address of the NFS file server that your DataSync agent connects to.
     */
    public val serverHostname: kotlin.String? = builder.serverHostname
    /**
     * Specifies the export path in your NFS file server that you want DataSync to mount.
     *
     * This path (or a subdirectory of the path) is where DataSync transfers data to or from. For information on configuring an export for DataSync, see [Accessing NFS file servers](https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#accessing-nfs).
     */
    public val subdirectory: kotlin.String? = builder.subdirectory
    /**
     * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We recommend creating at least a name tag for your location.
     */
    public val tags: List<TagListEntry>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.CreateLocationNfsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLocationNfsRequest(")
        append("mountOptions=$mountOptions,")
        append("onPremConfig=$onPremConfig,")
        append("serverHostname=$serverHostname,")
        append("subdirectory=$subdirectory,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = mountOptions?.hashCode() ?: 0
        result = 31 * result + (onPremConfig?.hashCode() ?: 0)
        result = 31 * result + (serverHostname?.hashCode() ?: 0)
        result = 31 * result + (subdirectory?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateLocationNfsRequest

        if (mountOptions != other.mountOptions) return false
        if (onPremConfig != other.onPremConfig) return false
        if (serverHostname != other.serverHostname) return false
        if (subdirectory != other.subdirectory) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.CreateLocationNfsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the options that DataSync can use to mount your NFS file server.
         */
        public var mountOptions: aws.sdk.kotlin.services.datasync.model.NfsMountOptions? = null
        /**
         * Specifies the Amazon Resource Name (ARN) of the DataSync agent that want to connect to your NFS file server.
         *
         * You can specify more than one agent. For more information, see [Using multiple agents for transfers](https://docs.aws.amazon.com/datasync/latest/userguide/multiple-agents.html).
         */
        public var onPremConfig: aws.sdk.kotlin.services.datasync.model.OnPremConfig? = null
        /**
         * Specifies the Domain Name System (DNS) name or IP version 4 address of the NFS file server that your DataSync agent connects to.
         */
        public var serverHostname: kotlin.String? = null
        /**
         * Specifies the export path in your NFS file server that you want DataSync to mount.
         *
         * This path (or a subdirectory of the path) is where DataSync transfers data to or from. For information on configuring an export for DataSync, see [Accessing NFS file servers](https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#accessing-nfs).
         */
        public var subdirectory: kotlin.String? = null
        /**
         * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We recommend creating at least a name tag for your location.
         */
        public var tags: List<TagListEntry>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.CreateLocationNfsRequest) : this() {
            this.mountOptions = x.mountOptions
            this.onPremConfig = x.onPremConfig
            this.serverHostname = x.serverHostname
            this.subdirectory = x.subdirectory
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.CreateLocationNfsRequest = CreateLocationNfsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.NfsMountOptions] inside the given [block]
         */
        public fun mountOptions(block: aws.sdk.kotlin.services.datasync.model.NfsMountOptions.Builder.() -> kotlin.Unit) {
            this.mountOptions = aws.sdk.kotlin.services.datasync.model.NfsMountOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.OnPremConfig] inside the given [block]
         */
        public fun onPremConfig(block: aws.sdk.kotlin.services.datasync.model.OnPremConfig.Builder.() -> kotlin.Unit) {
            this.onPremConfig = aws.sdk.kotlin.services.datasync.model.OnPremConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
