// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model



public class CreateLocationFsxWindowsRequest private constructor(builder: Builder) {
    /**
     * Specifies the name of the Windows domain that the FSx for Windows File Server belongs to.
     *
     * If you have multiple domains in your environment, configuring this parameter makes sure that DataSync connects to the right file server.
     *
     * For more information, see [required permissions](https://docs.aws.amazon.com/datasync/latest/userguide/create-fsx-location.html#create-fsx-windows-location-permissions) for FSx for Windows File Server locations.
     */
    public val domain: kotlin.String? = builder.domain
    /**
     * Specifies the Amazon Resource Name (ARN) for the FSx for Windows File Server file system.
     */
    public val fsxFilesystemArn: kotlin.String? = builder.fsxFilesystemArn
    /**
     * Specifies the password of the user who has the permissions to access files and folders in the file system.
     *
     * For more information, see [required permissions](https://docs.aws.amazon.com/datasync/latest/userguide/create-fsx-location.html#create-fsx-windows-location-permissions) for FSx for Windows File Server locations.
     */
    public val password: kotlin.String? = builder.password
    /**
     * Specifies the ARNs of the security groups that provide access to your file system's preferred subnet.
     *
     * If you choose a security group that doesn't allow connections from within itself, do one of the following:
     * + Configure the security group to allow it to communicate within itself.
     * + Choose a different security group that can communicate with the mount target's security group.
     */
    public val securityGroupArns: List<String>? = builder.securityGroupArns
    /**
     * Specifies a mount path for your file system using forward slashes. This is where DataSync reads or writes data (depending on if this is a source or destination location).
     */
    public val subdirectory: kotlin.String? = builder.subdirectory
    /**
     * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We recommend creating at least a name tag for your location.
     */
    public val tags: List<TagListEntry>? = builder.tags
    /**
     * Specifies the user who has the permissions to access files, folders, and metadata in your file system.
     *
     * For information about choosing a user with the right level of access for your transfer, see [required permissions](https://docs.aws.amazon.com/datasync/latest/userguide/create-fsx-location.html#create-fsx-windows-location-permissions) for FSx for Windows File Server locations.
     */
    public val user: kotlin.String? = builder.user

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.CreateLocationFsxWindowsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLocationFsxWindowsRequest(")
        append("domain=$domain,")
        append("fsxFilesystemArn=$fsxFilesystemArn,")
        append("password=*** Sensitive Data Redacted ***,")
        append("securityGroupArns=$securityGroupArns,")
        append("subdirectory=$subdirectory,")
        append("tags=$tags,")
        append("user=$user")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domain?.hashCode() ?: 0
        result = 31 * result + (fsxFilesystemArn?.hashCode() ?: 0)
        result = 31 * result + (password?.hashCode() ?: 0)
        result = 31 * result + (securityGroupArns?.hashCode() ?: 0)
        result = 31 * result + (subdirectory?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (user?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateLocationFsxWindowsRequest

        if (domain != other.domain) return false
        if (fsxFilesystemArn != other.fsxFilesystemArn) return false
        if (password != other.password) return false
        if (securityGroupArns != other.securityGroupArns) return false
        if (subdirectory != other.subdirectory) return false
        if (tags != other.tags) return false
        if (user != other.user) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.CreateLocationFsxWindowsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the name of the Windows domain that the FSx for Windows File Server belongs to.
         *
         * If you have multiple domains in your environment, configuring this parameter makes sure that DataSync connects to the right file server.
         *
         * For more information, see [required permissions](https://docs.aws.amazon.com/datasync/latest/userguide/create-fsx-location.html#create-fsx-windows-location-permissions) for FSx for Windows File Server locations.
         */
        public var domain: kotlin.String? = null
        /**
         * Specifies the Amazon Resource Name (ARN) for the FSx for Windows File Server file system.
         */
        public var fsxFilesystemArn: kotlin.String? = null
        /**
         * Specifies the password of the user who has the permissions to access files and folders in the file system.
         *
         * For more information, see [required permissions](https://docs.aws.amazon.com/datasync/latest/userguide/create-fsx-location.html#create-fsx-windows-location-permissions) for FSx for Windows File Server locations.
         */
        public var password: kotlin.String? = null
        /**
         * Specifies the ARNs of the security groups that provide access to your file system's preferred subnet.
         *
         * If you choose a security group that doesn't allow connections from within itself, do one of the following:
         * + Configure the security group to allow it to communicate within itself.
         * + Choose a different security group that can communicate with the mount target's security group.
         */
        public var securityGroupArns: List<String>? = null
        /**
         * Specifies a mount path for your file system using forward slashes. This is where DataSync reads or writes data (depending on if this is a source or destination location).
         */
        public var subdirectory: kotlin.String? = null
        /**
         * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We recommend creating at least a name tag for your location.
         */
        public var tags: List<TagListEntry>? = null
        /**
         * Specifies the user who has the permissions to access files, folders, and metadata in your file system.
         *
         * For information about choosing a user with the right level of access for your transfer, see [required permissions](https://docs.aws.amazon.com/datasync/latest/userguide/create-fsx-location.html#create-fsx-windows-location-permissions) for FSx for Windows File Server locations.
         */
        public var user: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.CreateLocationFsxWindowsRequest) : this() {
            this.domain = x.domain
            this.fsxFilesystemArn = x.fsxFilesystemArn
            this.password = x.password
            this.securityGroupArns = x.securityGroupArns
            this.subdirectory = x.subdirectory
            this.tags = x.tags
            this.user = x.user
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.CreateLocationFsxWindowsRequest = CreateLocationFsxWindowsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
