// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model



/**
 * CreateAgentRequest
 */
public class CreateAgentRequest private constructor(builder: Builder) {
    /**
     * Specifies your DataSync agent's activation key. If you don't have an activation key, see [Activate your agent](https://docs.aws.amazon.com/datasync/latest/userguide/activate-agent.html).
     */
    public val activationKey: kotlin.String? = builder.activationKey
    /**
     * Specifies a name for your agent. You can see this name in the DataSync console.
     */
    public val agentName: kotlin.String? = builder.agentName
    /**
     * Specifies the Amazon Resource Name (ARN) of the security group that protects your task's [network interfaces](https://docs.aws.amazon.com/datasync/latest/userguide/datasync-network.html#required-network-interfaces) when [using a virtual private cloud (VPC) endpoint](https://docs.aws.amazon.com/datasync/latest/userguide/choose-service-endpoint.html#choose-service-endpoint-vpc). You can only specify one ARN.
     */
    public val securityGroupArns: List<String>? = builder.securityGroupArns
    /**
     * Specifies the ARN of the subnet where you want to run your DataSync task when using a VPC endpoint. This is the subnet where DataSync creates and manages the [network interfaces](https://docs.aws.amazon.com/datasync/latest/userguide/datasync-network.html#required-network-interfaces) for your transfer. You can only specify one ARN.
     */
    public val subnetArns: List<String>? = builder.subnetArns
    /**
     * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We recommend creating at least one tag for your agent.
     */
    public val tags: List<TagListEntry>? = builder.tags
    /**
     * Specifies the ID of the VPC endpoint that you want your agent to connect to. For example, a VPC endpoint ID looks like `vpce-01234d5aff67890e1`.
     *
     * The VPC endpoint you use must include the DataSync service name (for example, `com.amazonaws.us-east-2.datasync`).
     */
    public val vpcEndpointId: kotlin.String? = builder.vpcEndpointId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.CreateAgentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAgentRequest(")
        append("activationKey=$activationKey,")
        append("agentName=$agentName,")
        append("securityGroupArns=$securityGroupArns,")
        append("subnetArns=$subnetArns,")
        append("tags=$tags,")
        append("vpcEndpointId=$vpcEndpointId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activationKey?.hashCode() ?: 0
        result = 31 * result + (agentName?.hashCode() ?: 0)
        result = 31 * result + (securityGroupArns?.hashCode() ?: 0)
        result = 31 * result + (subnetArns?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpointId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAgentRequest

        if (activationKey != other.activationKey) return false
        if (agentName != other.agentName) return false
        if (securityGroupArns != other.securityGroupArns) return false
        if (subnetArns != other.subnetArns) return false
        if (tags != other.tags) return false
        if (vpcEndpointId != other.vpcEndpointId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.CreateAgentRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies your DataSync agent's activation key. If you don't have an activation key, see [Activate your agent](https://docs.aws.amazon.com/datasync/latest/userguide/activate-agent.html).
         */
        public var activationKey: kotlin.String? = null
        /**
         * Specifies a name for your agent. You can see this name in the DataSync console.
         */
        public var agentName: kotlin.String? = null
        /**
         * Specifies the Amazon Resource Name (ARN) of the security group that protects your task's [network interfaces](https://docs.aws.amazon.com/datasync/latest/userguide/datasync-network.html#required-network-interfaces) when [using a virtual private cloud (VPC) endpoint](https://docs.aws.amazon.com/datasync/latest/userguide/choose-service-endpoint.html#choose-service-endpoint-vpc). You can only specify one ARN.
         */
        public var securityGroupArns: List<String>? = null
        /**
         * Specifies the ARN of the subnet where you want to run your DataSync task when using a VPC endpoint. This is the subnet where DataSync creates and manages the [network interfaces](https://docs.aws.amazon.com/datasync/latest/userguide/datasync-network.html#required-network-interfaces) for your transfer. You can only specify one ARN.
         */
        public var subnetArns: List<String>? = null
        /**
         * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We recommend creating at least one tag for your agent.
         */
        public var tags: List<TagListEntry>? = null
        /**
         * Specifies the ID of the VPC endpoint that you want your agent to connect to. For example, a VPC endpoint ID looks like `vpce-01234d5aff67890e1`.
         *
         * The VPC endpoint you use must include the DataSync service name (for example, `com.amazonaws.us-east-2.datasync`).
         */
        public var vpcEndpointId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.CreateAgentRequest) : this() {
            this.activationKey = x.activationKey
            this.agentName = x.agentName
            this.securityGroupArns = x.securityGroupArns
            this.subnetArns = x.subnetArns
            this.tags = x.tags
            this.vpcEndpointId = x.vpcEndpointId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.CreateAgentRequest = CreateAgentRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
