// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model



/**
 * Represents a single entry in a list (or array) of DataSync agents when you call the [ListAgents](https://docs.aws.amazon.com/datasync/latest/userguide/API_ListAgents.html) operation.
 */
public class AgentListEntry private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of a DataSync agent.
     */
    public val agentArn: kotlin.String? = builder.agentArn
    /**
     * The name of an agent.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The platform-related details about the agent, such as the version number.
     */
    public val platform: aws.sdk.kotlin.services.datasync.model.Platform? = builder.platform
    /**
     * The status of an agent.
     * + If the status is `ONLINE`, the agent is configured properly and ready to use.
     * + If the status is `OFFLINE`, the agent has been out of contact with DataSync for five minutes or longer. This can happen for a few reasons. For more information, see [What do I do if my agent is offline?](https://docs.aws.amazon.com/datasync/latest/userguide/troubleshooting-datasync-agents.html#troubleshoot-agent-offline)
     */
    public val status: aws.sdk.kotlin.services.datasync.model.AgentStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.AgentListEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AgentListEntry(")
        append("agentArn=$agentArn,")
        append("name=$name,")
        append("platform=$platform,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentArn?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AgentListEntry

        if (agentArn != other.agentArn) return false
        if (name != other.name) return false
        if (platform != other.platform) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.AgentListEntry = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of a DataSync agent.
         */
        public var agentArn: kotlin.String? = null
        /**
         * The name of an agent.
         */
        public var name: kotlin.String? = null
        /**
         * The platform-related details about the agent, such as the version number.
         */
        public var platform: aws.sdk.kotlin.services.datasync.model.Platform? = null
        /**
         * The status of an agent.
         * + If the status is `ONLINE`, the agent is configured properly and ready to use.
         * + If the status is `OFFLINE`, the agent has been out of contact with DataSync for five minutes or longer. This can happen for a few reasons. For more information, see [What do I do if my agent is offline?](https://docs.aws.amazon.com/datasync/latest/userguide/troubleshooting-datasync-agents.html#troubleshoot-agent-offline)
         */
        public var status: aws.sdk.kotlin.services.datasync.model.AgentStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.AgentListEntry) : this() {
            this.agentArn = x.agentArn
            this.name = x.name
            this.platform = x.platform
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.AgentListEntry = AgentListEntry(this)

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.Platform] inside the given [block]
         */
        public fun platform(block: aws.sdk.kotlin.services.datasync.model.Platform.Builder.() -> kotlin.Unit) {
            this.platform = aws.sdk.kotlin.services.datasync.model.Platform.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
