// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datapipeline.paginators

import aws.sdk.kotlin.services.datapipeline.DataPipelineClient
import aws.sdk.kotlin.services.datapipeline.model.DescribeObjectsRequest
import aws.sdk.kotlin.services.datapipeline.model.DescribeObjectsResponse
import aws.sdk.kotlin.services.datapipeline.model.ListPipelinesRequest
import aws.sdk.kotlin.services.datapipeline.model.ListPipelinesResponse
import aws.sdk.kotlin.services.datapipeline.model.PipelineIdName
import aws.sdk.kotlin.services.datapipeline.model.PipelineObject
import aws.sdk.kotlin.services.datapipeline.model.QueryObjectsRequest
import aws.sdk.kotlin.services.datapipeline.model.QueryObjectsResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeObjectsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeObjectsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeObjectsResponse]
 */
public fun DataPipelineClient.describeObjectsPaginated(initialRequest: DescribeObjectsRequest): Flow<DescribeObjectsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeObjectsPaginated.describeObjects(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeObjectsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeObjectsResponse]
 */
public fun DataPipelineClient.describeObjectsPaginated(block: DescribeObjectsRequest.Builder.() -> Unit): Flow<DescribeObjectsResponse> =
    describeObjectsPaginated(DescribeObjectsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeObjectsPaginated]
 * to access the nested member [PipelineObject]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PipelineObject]
 */
@JvmName("describeObjectsResponsePipelineObject")
public fun Flow<DescribeObjectsResponse>.pipelineObjects(): Flow<PipelineObject> =
    transform() { response ->
        response.pipelineObjects?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPipelinesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPipelinesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPipelinesResponse]
 */
public fun DataPipelineClient.listPipelinesPaginated(initialRequest: ListPipelinesRequest): Flow<ListPipelinesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listPipelinesPaginated.listPipelines(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPipelinesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPipelinesResponse]
 */
public fun DataPipelineClient.listPipelinesPaginated(block: ListPipelinesRequest.Builder.() -> Unit): Flow<ListPipelinesResponse> =
    listPipelinesPaginated(ListPipelinesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPipelinesPaginated]
 * to access the nested member [PipelineIdName]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PipelineIdName]
 */
@JvmName("listPipelinesResponsePipelineIdName")
public fun Flow<ListPipelinesResponse>.pipelineIdList(): Flow<PipelineIdName> =
    transform() { response ->
        response.pipelineIdList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [QueryObjectsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [QueryObjectsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [QueryObjectsResponse]
 */
public fun DataPipelineClient.queryObjectsPaginated(initialRequest: QueryObjectsRequest): Flow<QueryObjectsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@queryObjectsPaginated.queryObjects(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [QueryObjectsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [QueryObjectsResponse]
 */
public fun DataPipelineClient.queryObjectsPaginated(block: QueryObjectsRequest.Builder.() -> Unit): Flow<QueryObjectsResponse> =
    queryObjectsPaginated(QueryObjectsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [queryObjectsPaginated]
 * to access the nested member [Id]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Id]
 */
@JvmName("queryObjectsResponseId")
public fun Flow<QueryObjectsResponse>.ids(): Flow<String> =
    transform() { response ->
        response.ids?.forEach {
            emit(it)
        }
    }
