// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datapipeline.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.datapipeline.model.DataPipelineException
import aws.sdk.kotlin.services.datapipeline.model.ValidatePipelineDefinitionResponse
import aws.sdk.kotlin.services.datapipeline.model.ValidationError
import aws.sdk.kotlin.services.datapipeline.model.ValidationWarning
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ValidatePipelineDefinitionOperationDeserializer: HttpDeserialize<ValidatePipelineDefinitionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ValidatePipelineDefinitionResponse {
        if (!response.status.isSuccess()) {
            throwValidatePipelineDefinitionError(context, response)
        }
        val builder = ValidatePipelineDefinitionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeValidatePipelineDefinitionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwValidatePipelineDefinitionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DataPipelineException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServiceError" -> InternalServiceErrorDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "PipelineDeletedException" -> PipelineDeletedExceptionDeserializer().deserialize(context, wrappedResponse)
        "PipelineNotFoundException" -> PipelineNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> DataPipelineException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeValidatePipelineDefinitionOperationBody(builder: ValidatePipelineDefinitionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ERRORED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("errored"))
    val VALIDATIONERRORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("validationErrors"))
    val VALIDATIONWARNINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("validationWarnings"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ERRORED_DESCRIPTOR)
        field(VALIDATIONERRORS_DESCRIPTOR)
        field(VALIDATIONWARNINGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ERRORED_DESCRIPTOR.index -> builder.errored = deserializeBoolean()
                VALIDATIONERRORS_DESCRIPTOR.index -> builder.validationErrors =
                    deserializer.deserializeList(VALIDATIONERRORS_DESCRIPTOR) {
                        val col0 = mutableListOf<ValidationError>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeValidationErrorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                VALIDATIONWARNINGS_DESCRIPTOR.index -> builder.validationWarnings =
                    deserializer.deserializeList(VALIDATIONWARNINGS_DESCRIPTOR) {
                        val col0 = mutableListOf<ValidationWarning>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeValidationWarningDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
