// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datapipeline.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.datapipeline.model.DataPipelineException
import aws.sdk.kotlin.services.datapipeline.model.ListPipelinesResponse
import aws.sdk.kotlin.services.datapipeline.model.PipelineIdName
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListPipelinesOperationDeserializer: HttpDeserialize<ListPipelinesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListPipelinesResponse {
        if (!response.status.isSuccess()) {
            throwListPipelinesError(context, response)
        }
        val builder = ListPipelinesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListPipelinesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListPipelinesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DataPipelineException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServiceError" -> InternalServiceErrorDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> DataPipelineException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListPipelinesOperationBody(builder: ListPipelinesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val HASMORERESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("hasMoreResults"))
    val MARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("marker"))
    val PIPELINEIDLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("pipelineIdList"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(HASMORERESULTS_DESCRIPTOR)
        field(MARKER_DESCRIPTOR)
        field(PIPELINEIDLIST_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                HASMORERESULTS_DESCRIPTOR.index -> builder.hasMoreResults = deserializeBoolean()
                MARKER_DESCRIPTOR.index -> builder.marker = deserializeString()
                PIPELINEIDLIST_DESCRIPTOR.index -> builder.pipelineIdList =
                    deserializer.deserializeList(PIPELINEIDLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<PipelineIdName>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializePipelineIdNameDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
