// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datapipeline.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.datapipeline.model.DataPipelineException
import aws.sdk.kotlin.services.datapipeline.model.GetPipelineDefinitionResponse
import aws.sdk.kotlin.services.datapipeline.model.ParameterObject
import aws.sdk.kotlin.services.datapipeline.model.ParameterValue
import aws.sdk.kotlin.services.datapipeline.model.PipelineObject
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetPipelineDefinitionOperationDeserializer: HttpDeserialize<GetPipelineDefinitionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetPipelineDefinitionResponse {
        if (!response.status.isSuccess()) {
            throwGetPipelineDefinitionError(context, response)
        }
        val builder = GetPipelineDefinitionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetPipelineDefinitionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetPipelineDefinitionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DataPipelineException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServiceError" -> InternalServiceErrorDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "PipelineDeletedException" -> PipelineDeletedExceptionDeserializer().deserialize(context, wrappedResponse)
        "PipelineNotFoundException" -> PipelineNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> DataPipelineException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetPipelineDefinitionOperationBody(builder: GetPipelineDefinitionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PARAMETEROBJECTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("parameterObjects"))
    val PARAMETERVALUES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("parameterValues"))
    val PIPELINEOBJECTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("pipelineObjects"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PARAMETEROBJECTS_DESCRIPTOR)
        field(PARAMETERVALUES_DESCRIPTOR)
        field(PIPELINEOBJECTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PARAMETEROBJECTS_DESCRIPTOR.index -> builder.parameterObjects =
                    deserializer.deserializeList(PARAMETEROBJECTS_DESCRIPTOR) {
                        val col0 = mutableListOf<ParameterObject>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeParameterObjectDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PARAMETERVALUES_DESCRIPTOR.index -> builder.parameterValues =
                    deserializer.deserializeList(PARAMETERVALUES_DESCRIPTOR) {
                        val col0 = mutableListOf<ParameterValue>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeParameterValueDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PIPELINEOBJECTS_DESCRIPTOR.index -> builder.pipelineObjects =
                    deserializer.deserializeList(PIPELINEOBJECTS_DESCRIPTOR) {
                        val col0 = mutableListOf<PipelineObject>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializePipelineObjectDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
