// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datapipeline.model



/**
 * Contains the parameters for QueryObjects.
 */
public class QueryObjectsRequest private constructor(builder: Builder) {
    /**
     * The maximum number of object names that `QueryObjects` will return in a single call. The default value is 100.
     */
    public val limit: kotlin.Int? = builder.limit
    /**
     * The starting point for the results to be returned. For the first call, this value should be empty. As long as there are more results, continue to call `QueryObjects` with the marker value from the previous call to retrieve the next set of results.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The ID of the pipeline.
     */
    public val pipelineId: kotlin.String? = builder.pipelineId
    /**
     * The query that defines the objects to be returned. The `Query` object can contain a maximum of ten selectors. The conditions in the query are limited to top-level String fields in the object. These filters can be applied to components, instances, and attempts.
     */
    public val query: aws.sdk.kotlin.services.datapipeline.model.Query? = builder.query
    /**
     * Indicates whether the query applies to components or instances. The possible values are: `COMPONENT`, `INSTANCE`, and `ATTEMPT`.
     */
    public val sphere: kotlin.String? = builder.sphere

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datapipeline.model.QueryObjectsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QueryObjectsRequest(")
        append("limit=$limit,")
        append("marker=$marker,")
        append("pipelineId=$pipelineId,")
        append("query=$query,")
        append("sphere=$sphere")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = limit ?: 0
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (pipelineId?.hashCode() ?: 0)
        result = 31 * result + (query?.hashCode() ?: 0)
        result = 31 * result + (sphere?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QueryObjectsRequest

        if (limit != other.limit) return false
        if (marker != other.marker) return false
        if (pipelineId != other.pipelineId) return false
        if (query != other.query) return false
        if (sphere != other.sphere) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datapipeline.model.QueryObjectsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum number of object names that `QueryObjects` will return in a single call. The default value is 100.
         */
        public var limit: kotlin.Int? = null
        /**
         * The starting point for the results to be returned. For the first call, this value should be empty. As long as there are more results, continue to call `QueryObjects` with the marker value from the previous call to retrieve the next set of results.
         */
        public var marker: kotlin.String? = null
        /**
         * The ID of the pipeline.
         */
        public var pipelineId: kotlin.String? = null
        /**
         * The query that defines the objects to be returned. The `Query` object can contain a maximum of ten selectors. The conditions in the query are limited to top-level String fields in the object. These filters can be applied to components, instances, and attempts.
         */
        public var query: aws.sdk.kotlin.services.datapipeline.model.Query? = null
        /**
         * Indicates whether the query applies to components or instances. The possible values are: `COMPONENT`, `INSTANCE`, and `ATTEMPT`.
         */
        public var sphere: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datapipeline.model.QueryObjectsRequest) : this() {
            this.limit = x.limit
            this.marker = x.marker
            this.pipelineId = x.pipelineId
            this.query = x.query
            this.sphere = x.sphere
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datapipeline.model.QueryObjectsRequest = QueryObjectsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.datapipeline.model.Query] inside the given [block]
         */
        public fun query(block: aws.sdk.kotlin.services.datapipeline.model.Query.Builder.() -> kotlin.Unit) {
            this.query = aws.sdk.kotlin.services.datapipeline.model.Query.invoke(block)
        }
    }
}
