// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datapipeline.model



/**
 * Contains a logical operation for comparing the value of a field with a specified value.
 */
public class Operator private constructor(builder: Builder) {
    /**
     * The logical operation to be performed: equal (`EQ`), equal reference (`REF_EQ`), less than or equal (`LE`), greater than or equal (`GE`), or between (`BETWEEN`). Equal reference (`REF_EQ`) can be used only with reference fields. The other comparison types can be used only with String fields. The comparison types you can use apply only to certain object fields, as detailed below.
     *
     *  The comparison operators EQ and REF_EQ act on the following fields:
     * + name
     * + @sphere
     * + parent
     * + @componentParent
     * + @instanceParent
     * + @status
     * + @scheduledStartTime
     * + @scheduledEndTime
     * + @actualStartTime
     * + @actualEndTime
     *
     *  The comparison operators `GE`, `LE`, and `BETWEEN` act on the following fields:
     * + @scheduledStartTime
     * + @scheduledEndTime
     * + @actualStartTime
     * + @actualEndTime
     *
     * Note that fields beginning with the at sign (@) are read-only and set by the web service. When you name fields, you should choose names containing only alpha-numeric values, as symbols may be reserved by AWS Data Pipeline. User-defined fields that you add to a pipeline should prefix their name with the string "my".
     */
    public val type: aws.sdk.kotlin.services.datapipeline.model.OperatorType? = builder.type
    /**
     * The value that the actual field value will be compared with.
     */
    public val values: List<String>? = builder.values

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datapipeline.model.Operator = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Operator(")
        append("type=$type,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = type?.hashCode() ?: 0
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Operator

        if (type != other.type) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datapipeline.model.Operator = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The logical operation to be performed: equal (`EQ`), equal reference (`REF_EQ`), less than or equal (`LE`), greater than or equal (`GE`), or between (`BETWEEN`). Equal reference (`REF_EQ`) can be used only with reference fields. The other comparison types can be used only with String fields. The comparison types you can use apply only to certain object fields, as detailed below.
         *
         *  The comparison operators EQ and REF_EQ act on the following fields:
         * + name
         * + @sphere
         * + parent
         * + @componentParent
         * + @instanceParent
         * + @status
         * + @scheduledStartTime
         * + @scheduledEndTime
         * + @actualStartTime
         * + @actualEndTime
         *
         *  The comparison operators `GE`, `LE`, and `BETWEEN` act on the following fields:
         * + @scheduledStartTime
         * + @scheduledEndTime
         * + @actualStartTime
         * + @actualEndTime
         *
         * Note that fields beginning with the at sign (@) are read-only and set by the web service. When you name fields, you should choose names containing only alpha-numeric values, as symbols may be reserved by AWS Data Pipeline. User-defined fields that you add to a pipeline should prefix their name with the string "my".
         */
        public var type: aws.sdk.kotlin.services.datapipeline.model.OperatorType? = null
        /**
         * The value that the actual field value will be compared with.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datapipeline.model.Operator) : this() {
            this.type = x.type
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datapipeline.model.Operator = Operator(this)
    }
}
