// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datapipeline.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.datapipeline.model.DataPipelineException
import aws.sdk.kotlin.services.datapipeline.model.PollForTaskResponse
import aws.sdk.kotlin.services.datapipeline.model.TaskObject
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PollForTaskOperationDeserializer: HttpDeserialize<PollForTaskResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): PollForTaskResponse {
        if (!response.status.isSuccess()) {
            throwPollForTaskError(context, response)
        }
        val builder = PollForTaskResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePollForTaskOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwPollForTaskError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DataPipelineException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServiceError" -> InternalServiceErrorDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "TaskNotFoundException" -> TaskNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> DataPipelineException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePollForTaskOperationBody(builder: PollForTaskResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val TASKOBJECT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("taskObject"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(TASKOBJECT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                TASKOBJECT_DESCRIPTOR.index -> builder.taskObject = deserializeTaskObjectDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
