// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datapipeline.model



/**
 * Contains the parameters for ReportTaskRunnerHeartbeat.
 */
class ReportTaskRunnerHeartbeatRequest private constructor(builder: Builder) {
    /**
     * The public DNS name of the task runner.
     */
    val hostname: kotlin.String? = builder.hostname
    /**
     * The ID of the task runner. This value should be unique across your AWS account. In the case of AWS Data Pipeline Task Runner launched on a resource managed by AWS Data Pipeline, the web service provides a unique identifier when it launches the application. If you have written a custom task runner, you should assign a unique identifier for the task runner.
     */
    val taskrunnerId: kotlin.String? = builder.taskrunnerId
    /**
     * The type of task the task runner is configured to accept and process. The worker group is set as a field on objects in the pipeline when they are created. You can only specify a single value for `workerGroup`. There are no wildcard values permitted in `workerGroup`; the string must be an exact, case-sensitive, match.
     */
    val workerGroup: kotlin.String? = builder.workerGroup

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReportTaskRunnerHeartbeatRequest(")
        append("hostname=$hostname,")
        append("taskrunnerId=$taskrunnerId,")
        append("workerGroup=$workerGroup)")
    }

    override fun hashCode(): kotlin.Int {
        var result = hostname?.hashCode() ?: 0
        result = 31 * result + (taskrunnerId?.hashCode() ?: 0)
        result = 31 * result + (workerGroup?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReportTaskRunnerHeartbeatRequest

        if (hostname != other.hostname) return false
        if (taskrunnerId != other.taskrunnerId) return false
        if (workerGroup != other.workerGroup) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The public DNS name of the task runner.
         */
        var hostname: kotlin.String? = null
        /**
         * The ID of the task runner. This value should be unique across your AWS account. In the case of AWS Data Pipeline Task Runner launched on a resource managed by AWS Data Pipeline, the web service provides a unique identifier when it launches the application. If you have written a custom task runner, you should assign a unique identifier for the task runner.
         */
        var taskrunnerId: kotlin.String? = null
        /**
         * The type of task the task runner is configured to accept and process. The worker group is set as a field on objects in the pipeline when they are created. You can only specify a single value for `workerGroup`. There are no wildcard values permitted in `workerGroup`; the string must be an exact, case-sensitive, match.
         */
        var workerGroup: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest) : this() {
            this.hostname = x.hostname
            this.taskrunnerId = x.taskrunnerId
            this.workerGroup = x.workerGroup
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest = ReportTaskRunnerHeartbeatRequest(this)
    }
}
