// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datapipeline.model



/**
 * Contains the parameters for DescribeObjects.
 */
class DescribeObjectsRequest private constructor(builder: Builder) {
    /**
     * Indicates whether any expressions in the object should be evaluated when the object descriptions are returned.
     */
    val evaluateExpressions: kotlin.Boolean = builder.evaluateExpressions
    /**
     * The starting point for the results to be returned. For the first call, this value should be empty. As long as there are more results, continue to call `DescribeObjects` with the marker value from the previous call to retrieve the next set of results.
     */
    val marker: kotlin.String? = builder.marker
    /**
     * The IDs of the pipeline objects that contain the definitions to be described. You can pass as many as 25 identifiers in a single call to `DescribeObjects`.
     */
    val objectIds: List<String>? = builder.objectIds
    /**
     * The ID of the pipeline that contains the object definitions.
     */
    val pipelineId: kotlin.String? = builder.pipelineId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datapipeline.model.DescribeObjectsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeObjectsRequest(")
        append("evaluateExpressions=$evaluateExpressions,")
        append("marker=$marker,")
        append("objectIds=$objectIds,")
        append("pipelineId=$pipelineId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = evaluateExpressions.hashCode()
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (objectIds?.hashCode() ?: 0)
        result = 31 * result + (pipelineId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeObjectsRequest

        if (evaluateExpressions != other.evaluateExpressions) return false
        if (marker != other.marker) return false
        if (objectIds != other.objectIds) return false
        if (pipelineId != other.pipelineId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datapipeline.model.DescribeObjectsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates whether any expressions in the object should be evaluated when the object descriptions are returned.
         */
        var evaluateExpressions: kotlin.Boolean = false
        /**
         * The starting point for the results to be returned. For the first call, this value should be empty. As long as there are more results, continue to call `DescribeObjects` with the marker value from the previous call to retrieve the next set of results.
         */
        var marker: kotlin.String? = null
        /**
         * The IDs of the pipeline objects that contain the definitions to be described. You can pass as many as 25 identifiers in a single call to `DescribeObjects`.
         */
        var objectIds: List<String>? = null
        /**
         * The ID of the pipeline that contains the object definitions.
         */
        var pipelineId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datapipeline.model.DescribeObjectsRequest) : this() {
            this.evaluateExpressions = x.evaluateExpressions
            this.marker = x.marker
            this.objectIds = x.objectIds
            this.pipelineId = x.pipelineId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datapipeline.model.DescribeObjectsRequest = DescribeObjectsRequest(this)
    }
}
