// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datapipeline.model



/**
 * Contains information about a pipeline task that is assigned to a task runner.
 */
class TaskObject private constructor(builder: Builder) {
    /**
     * The ID of the pipeline task attempt object. AWS Data Pipeline uses this value to track how many times a task is attempted.
     */
    val attemptId: kotlin.String? = builder.attemptId
    /**
     * Connection information for the location where the task runner will publish the output of the task.
     */
    val objects: Map<String, PipelineObject>? = builder.objects
    /**
     * The ID of the pipeline that provided the task.
     */
    val pipelineId: kotlin.String? = builder.pipelineId
    /**
     * An internal identifier for the task. This ID is passed to the SetTaskStatus and ReportTaskProgress actions.
     */
    val taskId: kotlin.String? = builder.taskId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datapipeline.model.TaskObject = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TaskObject(")
        append("attemptId=$attemptId,")
        append("objects=$objects,")
        append("pipelineId=$pipelineId,")
        append("taskId=$taskId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attemptId?.hashCode() ?: 0
        result = 31 * result + (objects?.hashCode() ?: 0)
        result = 31 * result + (pipelineId?.hashCode() ?: 0)
        result = 31 * result + (taskId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TaskObject

        if (attemptId != other.attemptId) return false
        if (objects != other.objects) return false
        if (pipelineId != other.pipelineId) return false
        if (taskId != other.taskId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datapipeline.model.TaskObject = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID of the pipeline task attempt object. AWS Data Pipeline uses this value to track how many times a task is attempted.
         */
        var attemptId: kotlin.String? = null
        /**
         * Connection information for the location where the task runner will publish the output of the task.
         */
        var objects: Map<String, PipelineObject>? = null
        /**
         * The ID of the pipeline that provided the task.
         */
        var pipelineId: kotlin.String? = null
        /**
         * An internal identifier for the task. This ID is passed to the SetTaskStatus and ReportTaskProgress actions.
         */
        var taskId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datapipeline.model.TaskObject) : this() {
            this.attemptId = x.attemptId
            this.objects = x.objects
            this.pipelineId = x.pipelineId
            this.taskId = x.taskId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datapipeline.model.TaskObject = TaskObject(this)
    }
}
