// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datapipeline.model



/**
 * Identity information for the EC2 instance that is hosting the task runner. You can get this value by calling a metadata URI from the EC2 instance. For more information, see [Instance Metadata](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AESDG-chapter-instancedata.html) in the *Amazon Elastic Compute Cloud User Guide.* Passing in this value proves that your task runner is running on an EC2 instance, and ensures the proper AWS Data Pipeline service charges are applied to your pipeline.
 */
class InstanceIdentity private constructor(builder: Builder) {
    /**
     * A description of an EC2 instance that is generated when the instance is launched and exposed to the instance via the instance metadata service in the form of a JSON representation of an object.
     */
    val document: kotlin.String? = builder.document
    /**
     * A signature which can be used to verify the accuracy and authenticity of the information provided in the instance identity document.
     */
    val signature: kotlin.String? = builder.signature

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datapipeline.model.InstanceIdentity = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceIdentity(")
        append("document=$document,")
        append("signature=$signature)")
    }

    override fun hashCode(): kotlin.Int {
        var result = document?.hashCode() ?: 0
        result = 31 * result + (signature?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceIdentity

        if (document != other.document) return false
        if (signature != other.signature) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datapipeline.model.InstanceIdentity = Builder(this).apply(block).build()

    class Builder {
        /**
         * A description of an EC2 instance that is generated when the instance is launched and exposed to the instance via the instance metadata service in the form of a JSON representation of an object.
         */
        var document: kotlin.String? = null
        /**
         * A signature which can be used to verify the accuracy and authenticity of the information provided in the instance identity document.
         */
        var signature: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datapipeline.model.InstanceIdentity) : this() {
            this.document = x.document
            this.signature = x.signature
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datapipeline.model.InstanceIdentity = InstanceIdentity(this)
    }
}
