// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datapipeline.serde

import aws.sdk.kotlin.services.datapipeline.model.DataPipelineException
import aws.sdk.kotlin.services.datapipeline.model.QueryObjectsResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class QueryObjectsOperationDeserializer: HttpDeserializer.NonStreaming<QueryObjectsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): QueryObjectsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwQueryObjectsError(context, call, payload)
        }
        val builder = QueryObjectsResponse.Builder()

        if (payload != null) {
            deserializeQueryObjectsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwQueryObjectsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DataPipelineException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "PipelineNotFoundException" -> PipelineNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServiceError" -> InternalServiceErrorDeserializer().deserialize(context, wrappedCall, payload)
        "PipelineDeletedException" -> PipelineDeletedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> DataPipelineException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeQueryObjectsOperationBody(builder: QueryObjectsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val HASMORERESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("hasMoreResults"))
    val IDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ids"))
    val MARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("marker"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(HASMORERESULTS_DESCRIPTOR)
        field(IDS_DESCRIPTOR)
        field(MARKER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                HASMORERESULTS_DESCRIPTOR.index -> builder.hasMoreResults = deserializeBoolean()
                IDS_DESCRIPTOR.index -> builder.ids =
                    deserializer.deserializeList(IDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                MARKER_DESCRIPTOR.index -> builder.marker = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
