// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datapipeline.serde

import aws.sdk.kotlin.services.datapipeline.model.DataPipelineException
import aws.sdk.kotlin.services.datapipeline.model.PutPipelineDefinitionResponse
import aws.sdk.kotlin.services.datapipeline.model.ValidationError
import aws.sdk.kotlin.services.datapipeline.model.ValidationWarning
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class PutPipelineDefinitionOperationDeserializer: HttpDeserializer.NonStreaming<PutPipelineDefinitionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): PutPipelineDefinitionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPutPipelineDefinitionError(context, call, payload)
        }
        val builder = PutPipelineDefinitionResponse.Builder()

        if (payload != null) {
            deserializePutPipelineDefinitionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwPutPipelineDefinitionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DataPipelineException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "PipelineNotFoundException" -> PipelineNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServiceError" -> InternalServiceErrorDeserializer().deserialize(context, wrappedCall, payload)
        "PipelineDeletedException" -> PipelineDeletedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> DataPipelineException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutPipelineDefinitionOperationBody(builder: PutPipelineDefinitionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ERRORED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("errored"))
    val VALIDATIONERRORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("validationErrors"))
    val VALIDATIONWARNINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("validationWarnings"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ERRORED_DESCRIPTOR)
        field(VALIDATIONERRORS_DESCRIPTOR)
        field(VALIDATIONWARNINGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ERRORED_DESCRIPTOR.index -> builder.errored = deserializeBoolean()
                VALIDATIONERRORS_DESCRIPTOR.index -> builder.validationErrors =
                    deserializer.deserializeList(VALIDATIONERRORS_DESCRIPTOR) {
                        val col0 = mutableListOf<ValidationError>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeValidationErrorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                VALIDATIONWARNINGS_DESCRIPTOR.index -> builder.validationWarnings =
                    deserializer.deserializeList(VALIDATIONWARNINGS_DESCRIPTOR) {
                        val col0 = mutableListOf<ValidationWarning>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeValidationWarningDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
