// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datapipeline.serde

import aws.sdk.kotlin.services.datapipeline.model.DataPipelineException
import aws.sdk.kotlin.services.datapipeline.model.GetPipelineDefinitionResponse
import aws.sdk.kotlin.services.datapipeline.model.ParameterObject
import aws.sdk.kotlin.services.datapipeline.model.ParameterValue
import aws.sdk.kotlin.services.datapipeline.model.PipelineObject
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetPipelineDefinitionOperationDeserializer: HttpDeserializer.NonStreaming<GetPipelineDefinitionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetPipelineDefinitionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetPipelineDefinitionError(context, call, payload)
        }
        val builder = GetPipelineDefinitionResponse.Builder()

        if (payload != null) {
            deserializeGetPipelineDefinitionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetPipelineDefinitionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DataPipelineException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "PipelineNotFoundException" -> PipelineNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServiceError" -> InternalServiceErrorDeserializer().deserialize(context, wrappedCall, payload)
        "PipelineDeletedException" -> PipelineDeletedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> DataPipelineException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetPipelineDefinitionOperationBody(builder: GetPipelineDefinitionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PARAMETEROBJECTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("parameterObjects"))
    val PARAMETERVALUES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("parameterValues"))
    val PIPELINEOBJECTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("pipelineObjects"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PARAMETEROBJECTS_DESCRIPTOR)
        field(PARAMETERVALUES_DESCRIPTOR)
        field(PIPELINEOBJECTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PARAMETEROBJECTS_DESCRIPTOR.index -> builder.parameterObjects =
                    deserializer.deserializeList(PARAMETEROBJECTS_DESCRIPTOR) {
                        val col0 = mutableListOf<ParameterObject>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeParameterObjectDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PARAMETERVALUES_DESCRIPTOR.index -> builder.parameterValues =
                    deserializer.deserializeList(PARAMETERVALUES_DESCRIPTOR) {
                        val col0 = mutableListOf<ParameterValue>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeParameterValueDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PIPELINEOBJECTS_DESCRIPTOR.index -> builder.pipelineObjects =
                    deserializer.deserializeList(PIPELINEOBJECTS_DESCRIPTOR) {
                        val col0 = mutableListOf<PipelineObject>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializePipelineObjectDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
