// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datapipeline.serde

import aws.sdk.kotlin.services.datapipeline.model.DataPipelineException
import aws.sdk.kotlin.services.datapipeline.model.EvaluateExpressionResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class EvaluateExpressionOperationDeserializer: HttpDeserializer.NonStreaming<EvaluateExpressionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): EvaluateExpressionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwEvaluateExpressionError(context, call, payload)
        }
        val builder = EvaluateExpressionResponse.Builder()

        if (payload != null) {
            deserializeEvaluateExpressionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwEvaluateExpressionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DataPipelineException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "PipelineNotFoundException" -> PipelineNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServiceError" -> InternalServiceErrorDeserializer().deserialize(context, wrappedCall, payload)
        "PipelineDeletedException" -> PipelineDeletedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TaskNotFoundException" -> TaskNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> DataPipelineException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeEvaluateExpressionOperationBody(builder: EvaluateExpressionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val EVALUATEDEXPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("evaluatedExpression"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EVALUATEDEXPRESSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                EVALUATEDEXPRESSION_DESCRIPTOR.index -> builder.evaluatedExpression = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
