// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datapipeline.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information about a pipeline task that is assigned to a task runner.
 */
public class TaskObject private constructor(builder: Builder) {
    /**
     * The ID of the pipeline task attempt object. AWS Data Pipeline uses this value to track how many times a task is attempted.
     */
    public val attemptId: kotlin.String? = builder.attemptId
    /**
     * Connection information for the location where the task runner will publish the output of the task.
     */
    public val objects: Map<String, PipelineObject>? = builder.objects
    /**
     * The ID of the pipeline that provided the task.
     */
    public val pipelineId: kotlin.String? = builder.pipelineId
    /**
     * An internal identifier for the task. This ID is passed to the SetTaskStatus and ReportTaskProgress actions.
     */
    public val taskId: kotlin.String? = builder.taskId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datapipeline.model.TaskObject = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TaskObject(")
        append("attemptId=$attemptId,")
        append("objects=$objects,")
        append("pipelineId=$pipelineId,")
        append("taskId=$taskId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attemptId?.hashCode() ?: 0
        result = 31 * result + (objects?.hashCode() ?: 0)
        result = 31 * result + (pipelineId?.hashCode() ?: 0)
        result = 31 * result + (taskId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TaskObject

        if (attemptId != other.attemptId) return false
        if (objects != other.objects) return false
        if (pipelineId != other.pipelineId) return false
        if (taskId != other.taskId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datapipeline.model.TaskObject = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the pipeline task attempt object. AWS Data Pipeline uses this value to track how many times a task is attempted.
         */
        public var attemptId: kotlin.String? = null
        /**
         * Connection information for the location where the task runner will publish the output of the task.
         */
        public var objects: Map<String, PipelineObject>? = null
        /**
         * The ID of the pipeline that provided the task.
         */
        public var pipelineId: kotlin.String? = null
        /**
         * An internal identifier for the task. This ID is passed to the SetTaskStatus and ReportTaskProgress actions.
         */
        public var taskId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datapipeline.model.TaskObject) : this() {
            this.attemptId = x.attemptId
            this.objects = x.objects
            this.pipelineId = x.pipelineId
            this.taskId = x.taskId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datapipeline.model.TaskObject = TaskObject(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
