// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datapipeline.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains the parameters for PollForTask.
 */
public class PollForTaskRequest private constructor(builder: Builder) {
    /**
     * The public DNS name of the calling task runner.
     */
    public val hostname: kotlin.String? = builder.hostname
    /**
     * Identity information for the EC2 instance that is hosting the task runner. You can get this value from the instance using `http://169.254.169.254/latest/meta-data/instance-id`. For more information, see [Instance Metadata](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AESDG-chapter-instancedata.html) in the *Amazon Elastic Compute Cloud User Guide.* Passing in this value proves that your task runner is running on an EC2 instance, and ensures the proper AWS Data Pipeline service charges are applied to your pipeline.
     */
    public val instanceIdentity: aws.sdk.kotlin.services.datapipeline.model.InstanceIdentity? = builder.instanceIdentity
    /**
     * The type of task the task runner is configured to accept and process. The worker group is set as a field on objects in the pipeline when they are created. You can only specify a single value for `workerGroup` in the call to `PollForTask`. There are no wildcard values permitted in `workerGroup`; the string must be an exact, case-sensitive, match.
     */
    public val workerGroup: kotlin.String? = builder.workerGroup

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datapipeline.model.PollForTaskRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PollForTaskRequest(")
        append("hostname=$hostname,")
        append("instanceIdentity=$instanceIdentity,")
        append("workerGroup=$workerGroup")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = hostname?.hashCode() ?: 0
        result = 31 * result + (instanceIdentity?.hashCode() ?: 0)
        result = 31 * result + (workerGroup?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PollForTaskRequest

        if (hostname != other.hostname) return false
        if (instanceIdentity != other.instanceIdentity) return false
        if (workerGroup != other.workerGroup) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datapipeline.model.PollForTaskRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The public DNS name of the calling task runner.
         */
        public var hostname: kotlin.String? = null
        /**
         * Identity information for the EC2 instance that is hosting the task runner. You can get this value from the instance using `http://169.254.169.254/latest/meta-data/instance-id`. For more information, see [Instance Metadata](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AESDG-chapter-instancedata.html) in the *Amazon Elastic Compute Cloud User Guide.* Passing in this value proves that your task runner is running on an EC2 instance, and ensures the proper AWS Data Pipeline service charges are applied to your pipeline.
         */
        public var instanceIdentity: aws.sdk.kotlin.services.datapipeline.model.InstanceIdentity? = null
        /**
         * The type of task the task runner is configured to accept and process. The worker group is set as a field on objects in the pipeline when they are created. You can only specify a single value for `workerGroup` in the call to `PollForTask`. There are no wildcard values permitted in `workerGroup`; the string must be an exact, case-sensitive, match.
         */
        public var workerGroup: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datapipeline.model.PollForTaskRequest) : this() {
            this.hostname = x.hostname
            this.instanceIdentity = x.instanceIdentity
            this.workerGroup = x.workerGroup
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datapipeline.model.PollForTaskRequest = PollForTaskRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.datapipeline.model.InstanceIdentity] inside the given [block]
         */
        public fun instanceIdentity(block: aws.sdk.kotlin.services.datapipeline.model.InstanceIdentity.Builder.() -> kotlin.Unit) {
            this.instanceIdentity = aws.sdk.kotlin.services.datapipeline.model.InstanceIdentity.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
