// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datapipeline.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains pipeline metadata.
 */
public class PipelineDescription private constructor(builder: Builder) {
    /**
     * Description of the pipeline.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A list of read-only fields that contain metadata about the pipeline: @userId, @accountId, and @pipelineState.
     */
    public val fields: List<Field> = requireNotNull(builder.fields) { "A non-null value must be provided for fields" }
    /**
     * The name of the pipeline.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The pipeline identifier that was assigned by AWS Data Pipeline. This is a string of the form `df-297EG78HU43EEXAMPLE`.
     */
    public val pipelineId: kotlin.String = requireNotNull(builder.pipelineId) { "A non-null value must be provided for pipelineId" }
    /**
     * A list of tags to associated with a pipeline. Tags let you control access to pipelines. For more information, see [Controlling User Access to Pipelines](http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html) in the *AWS Data Pipeline Developer Guide*.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datapipeline.model.PipelineDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PipelineDescription(")
        append("description=$description,")
        append("fields=$fields,")
        append("name=$name,")
        append("pipelineId=$pipelineId,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (fields.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (pipelineId.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PipelineDescription

        if (description != other.description) return false
        if (fields != other.fields) return false
        if (name != other.name) return false
        if (pipelineId != other.pipelineId) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datapipeline.model.PipelineDescription = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Description of the pipeline.
         */
        public var description: kotlin.String? = null
        /**
         * A list of read-only fields that contain metadata about the pipeline: @userId, @accountId, and @pipelineState.
         */
        public var fields: List<Field>? = null
        /**
         * The name of the pipeline.
         */
        public var name: kotlin.String? = null
        /**
         * The pipeline identifier that was assigned by AWS Data Pipeline. This is a string of the form `df-297EG78HU43EEXAMPLE`.
         */
        public var pipelineId: kotlin.String? = null
        /**
         * A list of tags to associated with a pipeline. Tags let you control access to pipelines. For more information, see [Controlling User Access to Pipelines](http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html) in the *AWS Data Pipeline Developer Guide*.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datapipeline.model.PipelineDescription) : this() {
            this.description = x.description
            this.fields = x.fields
            this.name = x.name
            this.pipelineId = x.pipelineId
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datapipeline.model.PipelineDescription = PipelineDescription(this)

        internal fun correctErrors(): Builder {
            if (fields == null) fields = emptyList()
            if (name == null) name = ""
            if (pipelineId == null) pipelineId = ""
            return this
        }
    }
}
