// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dataexchange.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.dataexchange.model.Action
import aws.sdk.kotlin.services.dataexchange.model.DataExchangeException
import aws.sdk.kotlin.services.dataexchange.model.Event
import aws.sdk.kotlin.services.dataexchange.model.UpdateEventActionResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class UpdateEventActionOperationDeserializer: HttpDeserialize<UpdateEventActionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateEventActionResponse {
        if (!response.status.isSuccess()) {
            throwUpdateEventActionError(context, response)
        }
        val builder = UpdateEventActionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateEventActionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateEventActionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DataExchangeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> DataExchangeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateEventActionOperationBody(builder: UpdateEventActionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Action"))
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedAt"))
    val EVENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Event"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Id"))
    val UPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("UpdatedAt"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTION_DESCRIPTOR)
        field(ARN_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(EVENT_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(UPDATEDAT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACTION_DESCRIPTOR.index -> builder.action = deserializeActionDocument(deserializer)
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromIso8601(it) }
                EVENT_DESCRIPTOR.index -> builder.event = deserializeEventDocument(deserializer)
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                UPDATEDAT_DESCRIPTOR.index -> builder.updatedAt = deserializeString().let { Instant.fromIso8601(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
