// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dataexchange.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.dataexchange.model.DataExchangeException
import aws.sdk.kotlin.services.dataexchange.model.SendApiAssetResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class SendApiAssetOperationDeserializer: HttpDeserialize<SendApiAssetResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): SendApiAssetResponse {
        if (!response.status.isSuccess()) {
            throwSendApiAssetError(context, response)
        }
        val builder = SendApiAssetResponse.Builder()

        val keysForResponseHeaders = response.headers.names()
        if (keysForResponseHeaders.isNotEmpty()) {
            val map = mutableMapOf<String, String>()
            for (hdrKey in keysForResponseHeaders) {
                val el = response.headers[hdrKey] ?: continue
                map[hdrKey] = el
            }
            builder.responseHeaders = map
        } else {
            builder.responseHeaders = emptyMap()
        }

        val contents = response.body.readAll()?.decodeToString()
        builder.body = contents

        return builder.build()
    }
}

private suspend fun throwSendApiAssetError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DataExchangeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> DataExchangeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
