// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dataexchange.transform

import aws.sdk.kotlin.services.dataexchange.model.RevokeRevisionRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class RevokeRevisionOperationSerializer: HttpSerialize<RevokeRevisionRequest> {
    override suspend fun serialize(context: ExecutionContext, input: RevokeRevisionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "v1",
                "data-sets",
                "${input.dataSetId}".encodeLabel(),
                "revisions",
                "${input.revisionId}".encodeLabel(),
                "revoke",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeRevokeRevisionOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeRevokeRevisionOperationBody(context: ExecutionContext, input: RevokeRevisionRequest): ByteArray {
    val serializer = JsonSerializer()
    val REVOCATIONCOMMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RevocationComment"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(REVOCATIONCOMMENT_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.revocationComment?.let { field(REVOCATIONCOMMENT_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
