// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dataexchange.paginators

import aws.sdk.kotlin.services.dataexchange.DataExchangeClient
import aws.sdk.kotlin.services.dataexchange.model.AssetEntry
import aws.sdk.kotlin.services.dataexchange.model.DataSetEntry
import aws.sdk.kotlin.services.dataexchange.model.EventActionEntry
import aws.sdk.kotlin.services.dataexchange.model.JobEntry
import aws.sdk.kotlin.services.dataexchange.model.ListDataSetRevisionsRequest
import aws.sdk.kotlin.services.dataexchange.model.ListDataSetRevisionsResponse
import aws.sdk.kotlin.services.dataexchange.model.ListDataSetsRequest
import aws.sdk.kotlin.services.dataexchange.model.ListDataSetsResponse
import aws.sdk.kotlin.services.dataexchange.model.ListEventActionsRequest
import aws.sdk.kotlin.services.dataexchange.model.ListEventActionsResponse
import aws.sdk.kotlin.services.dataexchange.model.ListJobsRequest
import aws.sdk.kotlin.services.dataexchange.model.ListJobsResponse
import aws.sdk.kotlin.services.dataexchange.model.ListRevisionAssetsRequest
import aws.sdk.kotlin.services.dataexchange.model.ListRevisionAssetsResponse
import aws.sdk.kotlin.services.dataexchange.model.RevisionEntry
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListDataSetRevisionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDataSetRevisionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataSetRevisionsResponse]
 */
public fun DataExchangeClient.listDataSetRevisionsPaginated(initialRequest: ListDataSetRevisionsRequest): Flow<ListDataSetRevisionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDataSetRevisionsPaginated.listDataSetRevisions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDataSetRevisionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataSetRevisionsResponse]
 */
public fun DataExchangeClient.listDataSetRevisionsPaginated(block: ListDataSetRevisionsRequest.Builder.() -> Unit): Flow<ListDataSetRevisionsResponse> =
    listDataSetRevisionsPaginated(ListDataSetRevisionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDataSetRevisionsPaginated]
 * to access the nested member [RevisionEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RevisionEntry]
 */
@JvmName("listDataSetRevisionsResponseRevisionEntry")
public fun Flow<ListDataSetRevisionsResponse>.revisions(): Flow<RevisionEntry> =
    transform() { response ->
        response.revisions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDataSetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDataSetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataSetsResponse]
 */
public fun DataExchangeClient.listDataSetsPaginated(initialRequest: ListDataSetsRequest): Flow<ListDataSetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDataSetsPaginated.listDataSets(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDataSetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataSetsResponse]
 */
public fun DataExchangeClient.listDataSetsPaginated(block: ListDataSetsRequest.Builder.() -> Unit): Flow<ListDataSetsResponse> =
    listDataSetsPaginated(ListDataSetsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDataSetsPaginated]
 * to access the nested member [DataSetEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DataSetEntry]
 */
@JvmName("listDataSetsResponseDataSetEntry")
public fun Flow<ListDataSetsResponse>.dataSets(): Flow<DataSetEntry> =
    transform() { response ->
        response.dataSets?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListEventActionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEventActionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEventActionsResponse]
 */
public fun DataExchangeClient.listEventActionsPaginated(initialRequest: ListEventActionsRequest): Flow<ListEventActionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEventActionsPaginated.listEventActions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListEventActionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEventActionsResponse]
 */
public fun DataExchangeClient.listEventActionsPaginated(block: ListEventActionsRequest.Builder.() -> Unit): Flow<ListEventActionsResponse> =
    listEventActionsPaginated(ListEventActionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listEventActionsPaginated]
 * to access the nested member [EventActionEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EventActionEntry]
 */
@JvmName("listEventActionsResponseEventActionEntry")
public fun Flow<ListEventActionsResponse>.eventActions(): Flow<EventActionEntry> =
    transform() { response ->
        response.eventActions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJobsResponse]
 */
public fun DataExchangeClient.listJobsPaginated(initialRequest: ListJobsRequest): Flow<ListJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listJobsPaginated.listJobs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJobsResponse]
 */
public fun DataExchangeClient.listJobsPaginated(block: ListJobsRequest.Builder.() -> Unit): Flow<ListJobsResponse> =
    listJobsPaginated(ListJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listJobsPaginated]
 * to access the nested member [JobEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [JobEntry]
 */
@JvmName("listJobsResponseJobEntry")
public fun Flow<ListJobsResponse>.jobs(): Flow<JobEntry> =
    transform() { response ->
        response.jobs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRevisionAssetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRevisionAssetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRevisionAssetsResponse]
 */
public fun DataExchangeClient.listRevisionAssetsPaginated(initialRequest: ListRevisionAssetsRequest): Flow<ListRevisionAssetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRevisionAssetsPaginated.listRevisionAssets(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListRevisionAssetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRevisionAssetsResponse]
 */
public fun DataExchangeClient.listRevisionAssetsPaginated(block: ListRevisionAssetsRequest.Builder.() -> Unit): Flow<ListRevisionAssetsResponse> =
    listRevisionAssetsPaginated(ListRevisionAssetsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRevisionAssetsPaginated]
 * to access the nested member [AssetEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AssetEntry]
 */
@JvmName("listRevisionAssetsResponseAssetEntry")
public fun Flow<ListRevisionAssetsResponse>.assets(): Flow<AssetEntry> =
    transform() { response ->
        response.assets?.forEach {
            emit(it)
        }
    }
