// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dataexchange

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.dataexchange.model.*
import aws.sdk.kotlin.services.dataexchange.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "DataExchange"
public const val ServiceApiVersion: String = "2017-07-25"
public const val SdkVersion: String = "0.17.12-beta"

internal class DefaultDataExchangeClient(override val config: DataExchangeClient.Config) : DataExchangeClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * This operation cancels a job. Jobs can be cancelled only when they are in the WAITING state.
     */
    override suspend fun cancelJob(input: CancelJobRequest): CancelJobResponse {
        val op = SdkHttpOperation.build<CancelJobRequest, CancelJobResponse> {
            serializer = CancelJobOperationSerializer()
            deserializer = CancelJobOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "CancelJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dataexchange"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation creates a data set.
     */
    override suspend fun createDataSet(input: CreateDataSetRequest): CreateDataSetResponse {
        val op = SdkHttpOperation.build<CreateDataSetRequest, CreateDataSetResponse> {
            serializer = CreateDataSetOperationSerializer()
            deserializer = CreateDataSetOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateDataSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dataexchange"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation creates an event action.
     */
    override suspend fun createEventAction(input: CreateEventActionRequest): CreateEventActionResponse {
        val op = SdkHttpOperation.build<CreateEventActionRequest, CreateEventActionResponse> {
            serializer = CreateEventActionOperationSerializer()
            deserializer = CreateEventActionOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateEventAction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dataexchange"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation creates a job.
     */
    override suspend fun createJob(input: CreateJobRequest): CreateJobResponse {
        val op = SdkHttpOperation.build<CreateJobRequest, CreateJobResponse> {
            serializer = CreateJobOperationSerializer()
            deserializer = CreateJobOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dataexchange"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation creates a revision for a data set.
     */
    override suspend fun createRevision(input: CreateRevisionRequest): CreateRevisionResponse {
        val op = SdkHttpOperation.build<CreateRevisionRequest, CreateRevisionResponse> {
            serializer = CreateRevisionOperationSerializer()
            deserializer = CreateRevisionOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateRevision"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dataexchange"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation deletes an asset.
     */
    override suspend fun deleteAsset(input: DeleteAssetRequest): DeleteAssetResponse {
        val op = SdkHttpOperation.build<DeleteAssetRequest, DeleteAssetResponse> {
            serializer = DeleteAssetOperationSerializer()
            deserializer = DeleteAssetOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteAsset"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dataexchange"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation deletes a data set.
     */
    override suspend fun deleteDataSet(input: DeleteDataSetRequest): DeleteDataSetResponse {
        val op = SdkHttpOperation.build<DeleteDataSetRequest, DeleteDataSetResponse> {
            serializer = DeleteDataSetOperationSerializer()
            deserializer = DeleteDataSetOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteDataSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dataexchange"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation deletes the event action.
     */
    override suspend fun deleteEventAction(input: DeleteEventActionRequest): DeleteEventActionResponse {
        val op = SdkHttpOperation.build<DeleteEventActionRequest, DeleteEventActionResponse> {
            serializer = DeleteEventActionOperationSerializer()
            deserializer = DeleteEventActionOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteEventAction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dataexchange"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation deletes a revision.
     */
    override suspend fun deleteRevision(input: DeleteRevisionRequest): DeleteRevisionResponse {
        val op = SdkHttpOperation.build<DeleteRevisionRequest, DeleteRevisionResponse> {
            serializer = DeleteRevisionOperationSerializer()
            deserializer = DeleteRevisionOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteRevision"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dataexchange"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation returns information about an asset.
     */
    override suspend fun getAsset(input: GetAssetRequest): GetAssetResponse {
        val op = SdkHttpOperation.build<GetAssetRequest, GetAssetResponse> {
            serializer = GetAssetOperationSerializer()
            deserializer = GetAssetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAsset"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dataexchange"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation returns information about a data set.
     */
    override suspend fun getDataSet(input: GetDataSetRequest): GetDataSetResponse {
        val op = SdkHttpOperation.build<GetDataSetRequest, GetDataSetResponse> {
            serializer = GetDataSetOperationSerializer()
            deserializer = GetDataSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDataSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dataexchange"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation retrieves information about an event action.
     */
    override suspend fun getEventAction(input: GetEventActionRequest): GetEventActionResponse {
        val op = SdkHttpOperation.build<GetEventActionRequest, GetEventActionResponse> {
            serializer = GetEventActionOperationSerializer()
            deserializer = GetEventActionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEventAction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dataexchange"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation returns information about a job.
     */
    override suspend fun getJob(input: GetJobRequest): GetJobResponse {
        val op = SdkHttpOperation.build<GetJobRequest, GetJobResponse> {
            serializer = GetJobOperationSerializer()
            deserializer = GetJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dataexchange"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation returns information about a revision.
     */
    override suspend fun getRevision(input: GetRevisionRequest): GetRevisionResponse {
        val op = SdkHttpOperation.build<GetRevisionRequest, GetRevisionResponse> {
            serializer = GetRevisionOperationSerializer()
            deserializer = GetRevisionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRevision"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dataexchange"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation lists a data set's revisions sorted by CreatedAt in descending order.
     */
    override suspend fun listDataSetRevisions(input: ListDataSetRevisionsRequest): ListDataSetRevisionsResponse {
        val op = SdkHttpOperation.build<ListDataSetRevisionsRequest, ListDataSetRevisionsResponse> {
            serializer = ListDataSetRevisionsOperationSerializer()
            deserializer = ListDataSetRevisionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDataSetRevisions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dataexchange"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation lists your data sets. When listing by origin OWNED, results are sorted by CreatedAt in descending order. When listing by origin ENTITLED, there is no order and the maxResults parameter is ignored.
     */
    override suspend fun listDataSets(input: ListDataSetsRequest): ListDataSetsResponse {
        val op = SdkHttpOperation.build<ListDataSetsRequest, ListDataSetsResponse> {
            serializer = ListDataSetsOperationSerializer()
            deserializer = ListDataSetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDataSets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dataexchange"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation lists your event actions.
     */
    override suspend fun listEventActions(input: ListEventActionsRequest): ListEventActionsResponse {
        val op = SdkHttpOperation.build<ListEventActionsRequest, ListEventActionsResponse> {
            serializer = ListEventActionsOperationSerializer()
            deserializer = ListEventActionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEventActions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dataexchange"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation lists your jobs sorted by CreatedAt in descending order.
     */
    override suspend fun listJobs(input: ListJobsRequest): ListJobsResponse {
        val op = SdkHttpOperation.build<ListJobsRequest, ListJobsResponse> {
            serializer = ListJobsOperationSerializer()
            deserializer = ListJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dataexchange"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation lists a revision's assets sorted alphabetically in descending order.
     */
    override suspend fun listRevisionAssets(input: ListRevisionAssetsRequest): ListRevisionAssetsResponse {
        val op = SdkHttpOperation.build<ListRevisionAssetsRequest, ListRevisionAssetsResponse> {
            serializer = ListRevisionAssetsOperationSerializer()
            deserializer = ListRevisionAssetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListRevisionAssets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dataexchange"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation lists the tags on the resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dataexchange"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation revokes subscribers' access to a revision.
     */
    override suspend fun revokeRevision(input: RevokeRevisionRequest): RevokeRevisionResponse {
        val op = SdkHttpOperation.build<RevokeRevisionRequest, RevokeRevisionResponse> {
            serializer = RevokeRevisionOperationSerializer()
            deserializer = RevokeRevisionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RevokeRevision"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dataexchange"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation invokes an API Gateway API asset. The request is proxied to the provider’s API Gateway API.
     */
    override suspend fun sendApiAsset(input: SendApiAssetRequest): SendApiAssetResponse {
        val op = SdkHttpOperation.build<SendApiAssetRequest, SendApiAssetResponse> {
            serializer = SendApiAssetOperationSerializer()
            deserializer = SendApiAssetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SendApiAsset"
                hostPrefix = "api-fulfill."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dataexchange"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation starts a job.
     */
    override suspend fun startJob(input: StartJobRequest): StartJobResponse {
        val op = SdkHttpOperation.build<StartJobRequest, StartJobResponse> {
            serializer = StartJobOperationSerializer()
            deserializer = StartJobOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "StartJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dataexchange"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation tags a resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dataexchange"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation removes one or more tags from a resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dataexchange"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation updates an asset.
     */
    override suspend fun updateAsset(input: UpdateAssetRequest): UpdateAssetResponse {
        val op = SdkHttpOperation.build<UpdateAssetRequest, UpdateAssetResponse> {
            serializer = UpdateAssetOperationSerializer()
            deserializer = UpdateAssetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAsset"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dataexchange"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation updates a data set.
     */
    override suspend fun updateDataSet(input: UpdateDataSetRequest): UpdateDataSetResponse {
        val op = SdkHttpOperation.build<UpdateDataSetRequest, UpdateDataSetResponse> {
            serializer = UpdateDataSetOperationSerializer()
            deserializer = UpdateDataSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDataSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dataexchange"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation updates the event action.
     */
    override suspend fun updateEventAction(input: UpdateEventActionRequest): UpdateEventActionResponse {
        val op = SdkHttpOperation.build<UpdateEventActionRequest, UpdateEventActionResponse> {
            serializer = UpdateEventActionOperationSerializer()
            deserializer = UpdateEventActionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateEventAction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dataexchange"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation updates a revision.
     */
    override suspend fun updateRevision(input: UpdateRevisionRequest): UpdateRevisionResponse {
        val op = SdkHttpOperation.build<UpdateRevisionRequest, UpdateRevisionResponse> {
            serializer = UpdateRevisionOperationSerializer()
            deserializer = UpdateRevisionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateRevision"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dataexchange"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "dataexchange")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
