// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dataexchange

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.dataexchange.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.dataexchange.model.*
import aws.sdk.kotlin.services.dataexchange.model.CancelJobRequest
import aws.sdk.kotlin.services.dataexchange.model.CancelJobResponse
import aws.sdk.kotlin.services.dataexchange.model.CreateDataSetRequest
import aws.sdk.kotlin.services.dataexchange.model.CreateDataSetResponse
import aws.sdk.kotlin.services.dataexchange.model.CreateEventActionRequest
import aws.sdk.kotlin.services.dataexchange.model.CreateEventActionResponse
import aws.sdk.kotlin.services.dataexchange.model.CreateJobRequest
import aws.sdk.kotlin.services.dataexchange.model.CreateJobResponse
import aws.sdk.kotlin.services.dataexchange.model.CreateRevisionRequest
import aws.sdk.kotlin.services.dataexchange.model.CreateRevisionResponse
import aws.sdk.kotlin.services.dataexchange.model.DeleteAssetRequest
import aws.sdk.kotlin.services.dataexchange.model.DeleteAssetResponse
import aws.sdk.kotlin.services.dataexchange.model.DeleteDataSetRequest
import aws.sdk.kotlin.services.dataexchange.model.DeleteDataSetResponse
import aws.sdk.kotlin.services.dataexchange.model.DeleteEventActionRequest
import aws.sdk.kotlin.services.dataexchange.model.DeleteEventActionResponse
import aws.sdk.kotlin.services.dataexchange.model.DeleteRevisionRequest
import aws.sdk.kotlin.services.dataexchange.model.DeleteRevisionResponse
import aws.sdk.kotlin.services.dataexchange.model.GetAssetRequest
import aws.sdk.kotlin.services.dataexchange.model.GetAssetResponse
import aws.sdk.kotlin.services.dataexchange.model.GetDataSetRequest
import aws.sdk.kotlin.services.dataexchange.model.GetDataSetResponse
import aws.sdk.kotlin.services.dataexchange.model.GetEventActionRequest
import aws.sdk.kotlin.services.dataexchange.model.GetEventActionResponse
import aws.sdk.kotlin.services.dataexchange.model.GetJobRequest
import aws.sdk.kotlin.services.dataexchange.model.GetJobResponse
import aws.sdk.kotlin.services.dataexchange.model.GetRevisionRequest
import aws.sdk.kotlin.services.dataexchange.model.GetRevisionResponse
import aws.sdk.kotlin.services.dataexchange.model.ListDataSetRevisionsRequest
import aws.sdk.kotlin.services.dataexchange.model.ListDataSetRevisionsResponse
import aws.sdk.kotlin.services.dataexchange.model.ListDataSetsRequest
import aws.sdk.kotlin.services.dataexchange.model.ListDataSetsResponse
import aws.sdk.kotlin.services.dataexchange.model.ListEventActionsRequest
import aws.sdk.kotlin.services.dataexchange.model.ListEventActionsResponse
import aws.sdk.kotlin.services.dataexchange.model.ListJobsRequest
import aws.sdk.kotlin.services.dataexchange.model.ListJobsResponse
import aws.sdk.kotlin.services.dataexchange.model.ListRevisionAssetsRequest
import aws.sdk.kotlin.services.dataexchange.model.ListRevisionAssetsResponse
import aws.sdk.kotlin.services.dataexchange.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.dataexchange.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.dataexchange.model.RevokeRevisionRequest
import aws.sdk.kotlin.services.dataexchange.model.RevokeRevisionResponse
import aws.sdk.kotlin.services.dataexchange.model.SendApiAssetRequest
import aws.sdk.kotlin.services.dataexchange.model.SendApiAssetResponse
import aws.sdk.kotlin.services.dataexchange.model.StartJobRequest
import aws.sdk.kotlin.services.dataexchange.model.StartJobResponse
import aws.sdk.kotlin.services.dataexchange.model.TagResourceRequest
import aws.sdk.kotlin.services.dataexchange.model.TagResourceResponse
import aws.sdk.kotlin.services.dataexchange.model.UntagResourceRequest
import aws.sdk.kotlin.services.dataexchange.model.UntagResourceResponse
import aws.sdk.kotlin.services.dataexchange.model.UpdateAssetRequest
import aws.sdk.kotlin.services.dataexchange.model.UpdateAssetResponse
import aws.sdk.kotlin.services.dataexchange.model.UpdateDataSetRequest
import aws.sdk.kotlin.services.dataexchange.model.UpdateDataSetResponse
import aws.sdk.kotlin.services.dataexchange.model.UpdateEventActionRequest
import aws.sdk.kotlin.services.dataexchange.model.UpdateEventActionResponse
import aws.sdk.kotlin.services.dataexchange.model.UpdateRevisionRequest
import aws.sdk.kotlin.services.dataexchange.model.UpdateRevisionResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * AWS Data Exchange is a service that makes it easy for AWS customers to exchange data in the cloud. You can use the AWS Data Exchange APIs to create, update, manage, and access file-based data set in the AWS Cloud.
 *
 * As a subscriber, you can view and access the data sets that you have an entitlement to through a subscription. You can use the APIS to download or copy your entitled data sets to Amazon S3 for use across a variety of AWS analytics and machine learning services.
 *
 * As a provider, you can create and manage your data sets that you would like to publish to a product. Being able to package and provide your data sets into products requires a few steps to determine eligibility. For more information, visit the AWS Data Exchange User Guide.
 *
 * A data set is a collection of data that can be changed or updated over time. Data sets can be updated using revisions, which represent a new version or incremental change to a data set. A revision contains one or more assets. An asset in AWS Data Exchange is a piece of data that can be stored as an Amazon S3 object. The asset can be a structured data file, an image file, or some other data file. Jobs are asynchronous import or export operations used to create or copy assets.
 */
public interface DataExchangeClient : SdkClient {

    override val serviceName: String
        get() = "DataExchange"
    /**
     * DataExchangeClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): DataExchangeClient {
            val config = Config.Builder().apply(block).build()
            return DefaultDataExchangeClient(config)
        }

        public operator fun invoke(config: Config): DataExchangeClient = DefaultDataExchangeClient(config)

        /**
         * Construct a [DataExchangeClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): DataExchangeClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultDataExchangeClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * This operation cancels a job. Jobs can be cancelled only when they are in the WAITING state.
     */
    public suspend fun cancelJob(input: CancelJobRequest): CancelJobResponse

    /**
     * This operation creates a data set.
     */
    public suspend fun createDataSet(input: CreateDataSetRequest): CreateDataSetResponse

    /**
     * This operation creates an event action.
     */
    public suspend fun createEventAction(input: CreateEventActionRequest): CreateEventActionResponse

    /**
     * This operation creates a job.
     */
    public suspend fun createJob(input: CreateJobRequest): CreateJobResponse

    /**
     * This operation creates a revision for a data set.
     */
    public suspend fun createRevision(input: CreateRevisionRequest): CreateRevisionResponse

    /**
     * This operation deletes an asset.
     */
    public suspend fun deleteAsset(input: DeleteAssetRequest): DeleteAssetResponse

    /**
     * This operation deletes a data set.
     */
    public suspend fun deleteDataSet(input: DeleteDataSetRequest): DeleteDataSetResponse

    /**
     * This operation deletes the event action.
     */
    public suspend fun deleteEventAction(input: DeleteEventActionRequest): DeleteEventActionResponse

    /**
     * This operation deletes a revision.
     */
    public suspend fun deleteRevision(input: DeleteRevisionRequest): DeleteRevisionResponse

    /**
     * This operation returns information about an asset.
     */
    public suspend fun getAsset(input: GetAssetRequest): GetAssetResponse

    /**
     * This operation returns information about a data set.
     */
    public suspend fun getDataSet(input: GetDataSetRequest): GetDataSetResponse

    /**
     * This operation retrieves information about an event action.
     */
    public suspend fun getEventAction(input: GetEventActionRequest): GetEventActionResponse

    /**
     * This operation returns information about a job.
     */
    public suspend fun getJob(input: GetJobRequest): GetJobResponse

    /**
     * This operation returns information about a revision.
     */
    public suspend fun getRevision(input: GetRevisionRequest): GetRevisionResponse

    /**
     * This operation lists a data set's revisions sorted by CreatedAt in descending order.
     */
    public suspend fun listDataSetRevisions(input: ListDataSetRevisionsRequest): ListDataSetRevisionsResponse

    /**
     * This operation lists your data sets. When listing by origin OWNED, results are sorted by CreatedAt in descending order. When listing by origin ENTITLED, there is no order and the maxResults parameter is ignored.
     */
    public suspend fun listDataSets(input: ListDataSetsRequest = ListDataSetsRequest {}): ListDataSetsResponse

    /**
     * This operation lists your event actions.
     */
    public suspend fun listEventActions(input: ListEventActionsRequest = ListEventActionsRequest {}): ListEventActionsResponse

    /**
     * This operation lists your jobs sorted by CreatedAt in descending order.
     */
    public suspend fun listJobs(input: ListJobsRequest = ListJobsRequest {}): ListJobsResponse

    /**
     * This operation lists a revision's assets sorted alphabetically in descending order.
     */
    public suspend fun listRevisionAssets(input: ListRevisionAssetsRequest): ListRevisionAssetsResponse

    /**
     * This operation lists the tags on the resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * This operation revokes subscribers' access to a revision.
     */
    public suspend fun revokeRevision(input: RevokeRevisionRequest): RevokeRevisionResponse

    /**
     * This operation invokes an API Gateway API asset. The request is proxied to the provider’s API Gateway API.
     */
    public suspend fun sendApiAsset(input: SendApiAssetRequest): SendApiAssetResponse

    /**
     * This operation starts a job.
     */
    public suspend fun startJob(input: StartJobRequest): StartJobResponse

    /**
     * This operation tags a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * This operation removes one or more tags from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * This operation updates an asset.
     */
    public suspend fun updateAsset(input: UpdateAssetRequest): UpdateAssetResponse

    /**
     * This operation updates a data set.
     */
    public suspend fun updateDataSet(input: UpdateDataSetRequest): UpdateDataSetResponse

    /**
     * This operation updates the event action.
     */
    public suspend fun updateEventAction(input: UpdateEventActionRequest): UpdateEventActionResponse

    /**
     * This operation updates a revision.
     */
    public suspend fun updateRevision(input: UpdateRevisionRequest): UpdateRevisionResponse
}

/**
 * This operation cancels a job. Jobs can be cancelled only when they are in the WAITING state.
 */
public suspend inline fun DataExchangeClient.cancelJob(crossinline block: CancelJobRequest.Builder.() -> Unit): CancelJobResponse = cancelJob(CancelJobRequest.Builder().apply(block).build())

/**
 * This operation creates a data set.
 */
public suspend inline fun DataExchangeClient.createDataSet(crossinline block: CreateDataSetRequest.Builder.() -> Unit): CreateDataSetResponse = createDataSet(CreateDataSetRequest.Builder().apply(block).build())

/**
 * This operation creates an event action.
 */
public suspend inline fun DataExchangeClient.createEventAction(crossinline block: CreateEventActionRequest.Builder.() -> Unit): CreateEventActionResponse = createEventAction(CreateEventActionRequest.Builder().apply(block).build())

/**
 * This operation creates a job.
 */
public suspend inline fun DataExchangeClient.createJob(crossinline block: CreateJobRequest.Builder.() -> Unit): CreateJobResponse = createJob(CreateJobRequest.Builder().apply(block).build())

/**
 * This operation creates a revision for a data set.
 */
public suspend inline fun DataExchangeClient.createRevision(crossinline block: CreateRevisionRequest.Builder.() -> Unit): CreateRevisionResponse = createRevision(CreateRevisionRequest.Builder().apply(block).build())

/**
 * This operation deletes an asset.
 */
public suspend inline fun DataExchangeClient.deleteAsset(crossinline block: DeleteAssetRequest.Builder.() -> Unit): DeleteAssetResponse = deleteAsset(DeleteAssetRequest.Builder().apply(block).build())

/**
 * This operation deletes a data set.
 */
public suspend inline fun DataExchangeClient.deleteDataSet(crossinline block: DeleteDataSetRequest.Builder.() -> Unit): DeleteDataSetResponse = deleteDataSet(DeleteDataSetRequest.Builder().apply(block).build())

/**
 * This operation deletes the event action.
 */
public suspend inline fun DataExchangeClient.deleteEventAction(crossinline block: DeleteEventActionRequest.Builder.() -> Unit): DeleteEventActionResponse = deleteEventAction(DeleteEventActionRequest.Builder().apply(block).build())

/**
 * This operation deletes a revision.
 */
public suspend inline fun DataExchangeClient.deleteRevision(crossinline block: DeleteRevisionRequest.Builder.() -> Unit): DeleteRevisionResponse = deleteRevision(DeleteRevisionRequest.Builder().apply(block).build())

/**
 * This operation returns information about an asset.
 */
public suspend inline fun DataExchangeClient.getAsset(crossinline block: GetAssetRequest.Builder.() -> Unit): GetAssetResponse = getAsset(GetAssetRequest.Builder().apply(block).build())

/**
 * This operation returns information about a data set.
 */
public suspend inline fun DataExchangeClient.getDataSet(crossinline block: GetDataSetRequest.Builder.() -> Unit): GetDataSetResponse = getDataSet(GetDataSetRequest.Builder().apply(block).build())

/**
 * This operation retrieves information about an event action.
 */
public suspend inline fun DataExchangeClient.getEventAction(crossinline block: GetEventActionRequest.Builder.() -> Unit): GetEventActionResponse = getEventAction(GetEventActionRequest.Builder().apply(block).build())

/**
 * This operation returns information about a job.
 */
public suspend inline fun DataExchangeClient.getJob(crossinline block: GetJobRequest.Builder.() -> Unit): GetJobResponse = getJob(GetJobRequest.Builder().apply(block).build())

/**
 * This operation returns information about a revision.
 */
public suspend inline fun DataExchangeClient.getRevision(crossinline block: GetRevisionRequest.Builder.() -> Unit): GetRevisionResponse = getRevision(GetRevisionRequest.Builder().apply(block).build())

/**
 * This operation lists a data set's revisions sorted by CreatedAt in descending order.
 */
public suspend inline fun DataExchangeClient.listDataSetRevisions(crossinline block: ListDataSetRevisionsRequest.Builder.() -> Unit): ListDataSetRevisionsResponse = listDataSetRevisions(ListDataSetRevisionsRequest.Builder().apply(block).build())

/**
 * This operation lists your data sets. When listing by origin OWNED, results are sorted by CreatedAt in descending order. When listing by origin ENTITLED, there is no order and the maxResults parameter is ignored.
 */
public suspend inline fun DataExchangeClient.listDataSets(crossinline block: ListDataSetsRequest.Builder.() -> Unit): ListDataSetsResponse = listDataSets(ListDataSetsRequest.Builder().apply(block).build())

/**
 * This operation lists your event actions.
 */
public suspend inline fun DataExchangeClient.listEventActions(crossinline block: ListEventActionsRequest.Builder.() -> Unit): ListEventActionsResponse = listEventActions(ListEventActionsRequest.Builder().apply(block).build())

/**
 * This operation lists your jobs sorted by CreatedAt in descending order.
 */
public suspend inline fun DataExchangeClient.listJobs(crossinline block: ListJobsRequest.Builder.() -> Unit): ListJobsResponse = listJobs(ListJobsRequest.Builder().apply(block).build())

/**
 * This operation lists a revision's assets sorted alphabetically in descending order.
 */
public suspend inline fun DataExchangeClient.listRevisionAssets(crossinline block: ListRevisionAssetsRequest.Builder.() -> Unit): ListRevisionAssetsResponse = listRevisionAssets(ListRevisionAssetsRequest.Builder().apply(block).build())

/**
 * This operation lists the tags on the resource.
 */
public suspend inline fun DataExchangeClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * This operation revokes subscribers' access to a revision.
 */
public suspend inline fun DataExchangeClient.revokeRevision(crossinline block: RevokeRevisionRequest.Builder.() -> Unit): RevokeRevisionResponse = revokeRevision(RevokeRevisionRequest.Builder().apply(block).build())

/**
 * This operation invokes an API Gateway API asset. The request is proxied to the provider’s API Gateway API.
 */
public suspend inline fun DataExchangeClient.sendApiAsset(crossinline block: SendApiAssetRequest.Builder.() -> Unit): SendApiAssetResponse = sendApiAsset(SendApiAssetRequest.Builder().apply(block).build())

/**
 * This operation starts a job.
 */
public suspend inline fun DataExchangeClient.startJob(crossinline block: StartJobRequest.Builder.() -> Unit): StartJobResponse = startJob(StartJobRequest.Builder().apply(block).build())

/**
 * This operation tags a resource.
 */
public suspend inline fun DataExchangeClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * This operation removes one or more tags from a resource.
 */
public suspend inline fun DataExchangeClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * This operation updates an asset.
 */
public suspend inline fun DataExchangeClient.updateAsset(crossinline block: UpdateAssetRequest.Builder.() -> Unit): UpdateAssetResponse = updateAsset(UpdateAssetRequest.Builder().apply(block).build())

/**
 * This operation updates a data set.
 */
public suspend inline fun DataExchangeClient.updateDataSet(crossinline block: UpdateDataSetRequest.Builder.() -> Unit): UpdateDataSetResponse = updateDataSet(UpdateDataSetRequest.Builder().apply(block).build())

/**
 * This operation updates the event action.
 */
public suspend inline fun DataExchangeClient.updateEventAction(crossinline block: UpdateEventActionRequest.Builder.() -> Unit): UpdateEventActionResponse = updateEventAction(UpdateEventActionRequest.Builder().apply(block).build())

/**
 * This operation updates a revision.
 */
public suspend inline fun DataExchangeClient.updateRevision(crossinline block: UpdateRevisionRequest.Builder.() -> Unit): UpdateRevisionResponse = updateRevision(UpdateRevisionRequest.Builder().apply(block).build())
