// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dataexchange.serde

import aws.sdk.kotlin.services.dataexchange.model.DataExchangeException
import aws.sdk.kotlin.services.dataexchange.model.UpdateRevisionResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class UpdateRevisionOperationDeserializer: HttpDeserializer.NonStreaming<UpdateRevisionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateRevisionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateRevisionError(context, call, payload)
        }
        val builder = UpdateRevisionResponse.Builder()

        if (payload != null) {
            deserializeUpdateRevisionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateRevisionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DataExchangeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> DataExchangeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateRevisionOperationBody(builder: UpdateRevisionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val COMMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Comment"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedAt"))
    val DATASETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DataSetId"))
    val FINALIZED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("Finalized"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Id"))
    val REVOCATIONCOMMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RevocationComment"))
    val REVOKED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("Revoked"))
    val REVOKEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("RevokedAt"))
    val SOURCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourceId"))
    val UPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("UpdatedAt"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(COMMENT_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(DATASETID_DESCRIPTOR)
        field(FINALIZED_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(REVOCATIONCOMMENT_DESCRIPTOR)
        field(REVOKED_DESCRIPTOR)
        field(REVOKEDAT_DESCRIPTOR)
        field(SOURCEID_DESCRIPTOR)
        field(UPDATEDAT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                COMMENT_DESCRIPTOR.index -> builder.comment = deserializeString()
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromIso8601(it) }
                DATASETID_DESCRIPTOR.index -> builder.dataSetId = deserializeString()
                FINALIZED_DESCRIPTOR.index -> builder.finalized = deserializeBoolean()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                REVOCATIONCOMMENT_DESCRIPTOR.index -> builder.revocationComment = deserializeString()
                REVOKED_DESCRIPTOR.index -> builder.revoked = deserializeBoolean()
                REVOKEDAT_DESCRIPTOR.index -> builder.revokedAt = deserializeString().let { Instant.fromIso8601(it) }
                SOURCEID_DESCRIPTOR.index -> builder.sourceId = deserializeString()
                UPDATEDAT_DESCRIPTOR.index -> builder.updatedAt = deserializeString().let { Instant.fromIso8601(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
