// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dataexchange.model

import aws.smithy.kotlin.runtime.SdkDsl

public class SendApiAssetRequest private constructor(builder: Builder) {
    /**
     * Asset ID value for the API request.
     */
    public val assetId: kotlin.String = requireNotNull(builder.assetId) { "A non-null value must be provided for assetId" }
    /**
     * The request body.
     */
    public val body: kotlin.String? = builder.body
    /**
     * Data set ID value for the API request.
     */
    public val dataSetId: kotlin.String = requireNotNull(builder.dataSetId) { "A non-null value must be provided for dataSetId" }
    /**
     * HTTP method value for the API request. Alternatively, you can use the appropriate verb in your request.
     */
    public val method: kotlin.String? = builder.method
    /**
     * URI path value for the API request. Alternatively, you can set the URI path directly by invoking /v1/{pathValue}.
     */
    public val path: kotlin.String? = builder.path
    /**
     * Attach query string parameters to the end of the URI (for example, /v1/examplePath?exampleParam=exampleValue).
     */
    public val queryStringParameters: Map<String, String>? = builder.queryStringParameters
    /**
     * Any header value prefixed with x-amzn-dataexchange-header- will have that stripped before sending the Asset API request. Use this when you want to override a header that AWS Data Exchange uses. Alternatively, you can use the header without a prefix to the HTTP request.
     */
    public val requestHeaders: Map<String, String>? = builder.requestHeaders
    /**
     * Revision ID value for the API request.
     */
    public val revisionId: kotlin.String = requireNotNull(builder.revisionId) { "A non-null value must be provided for revisionId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dataexchange.model.SendApiAssetRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SendApiAssetRequest(")
        append("assetId=$assetId,")
        append("body=$body,")
        append("dataSetId=$dataSetId,")
        append("method=$method,")
        append("path=$path,")
        append("queryStringParameters=$queryStringParameters,")
        append("requestHeaders=$requestHeaders,")
        append("revisionId=$revisionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetId.hashCode()
        result = 31 * result + (body?.hashCode() ?: 0)
        result = 31 * result + (dataSetId.hashCode())
        result = 31 * result + (method?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (queryStringParameters?.hashCode() ?: 0)
        result = 31 * result + (requestHeaders?.hashCode() ?: 0)
        result = 31 * result + (revisionId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SendApiAssetRequest

        if (assetId != other.assetId) return false
        if (body != other.body) return false
        if (dataSetId != other.dataSetId) return false
        if (method != other.method) return false
        if (path != other.path) return false
        if (queryStringParameters != other.queryStringParameters) return false
        if (requestHeaders != other.requestHeaders) return false
        if (revisionId != other.revisionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dataexchange.model.SendApiAssetRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Asset ID value for the API request.
         */
        public var assetId: kotlin.String? = null
        /**
         * The request body.
         */
        public var body: kotlin.String? = null
        /**
         * Data set ID value for the API request.
         */
        public var dataSetId: kotlin.String? = null
        /**
         * HTTP method value for the API request. Alternatively, you can use the appropriate verb in your request.
         */
        public var method: kotlin.String? = null
        /**
         * URI path value for the API request. Alternatively, you can set the URI path directly by invoking /v1/{pathValue}.
         */
        public var path: kotlin.String? = null
        /**
         * Attach query string parameters to the end of the URI (for example, /v1/examplePath?exampleParam=exampleValue).
         */
        public var queryStringParameters: Map<String, String>? = null
        /**
         * Any header value prefixed with x-amzn-dataexchange-header- will have that stripped before sending the Asset API request. Use this when you want to override a header that AWS Data Exchange uses. Alternatively, you can use the header without a prefix to the HTTP request.
         */
        public var requestHeaders: Map<String, String>? = null
        /**
         * Revision ID value for the API request.
         */
        public var revisionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dataexchange.model.SendApiAssetRequest) : this() {
            this.assetId = x.assetId
            this.body = x.body
            this.dataSetId = x.dataSetId
            this.method = x.method
            this.path = x.path
            this.queryStringParameters = x.queryStringParameters
            this.requestHeaders = x.requestHeaders
            this.revisionId = x.revisionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dataexchange.model.SendApiAssetRequest = SendApiAssetRequest(this)

        internal fun correctErrors(): Builder {
            if (assetId == null) assetId = ""
            if (dataSetId == null) dataSetId = ""
            if (revisionId == null) revisionId = ""
            return this
        }
    }
}
