// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dataexchange.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The Amazon S3 data access that is the asset.
 */
public class S3DataAccessAsset private constructor(builder: Builder) {
    /**
     * The Amazon S3 bucket hosting data to be shared in the S3 data access.
     */
    public val bucket: kotlin.String = requireNotNull(builder.bucket) { "A non-null value must be provided for bucket" }
    /**
     * The Amazon S3 bucket used for hosting shared data in the Amazon S3 data access.
     */
    public val keyPrefixes: List<String>? = builder.keyPrefixes
    /**
     * S3 keys made available using this asset.
     */
    public val keys: List<String>? = builder.keys
    /**
     * List of AWS KMS CMKs (Key Management System Customer Managed Keys) and ARNs used to encrypt S3 objects being shared in this S3 Data Access asset. Providers must include all AWS KMS keys used to encrypt these shared S3 objects.
     */
    public val kmsKeysToGrant: List<KmsKeyToGrant>? = builder.kmsKeysToGrant
    /**
     * The automatically-generated bucket-style alias for your Amazon S3 Access Point. Customers can access their entitled data using the S3 Access Point alias.
     */
    public val s3AccessPointAlias: kotlin.String? = builder.s3AccessPointAlias
    /**
     * The ARN for your Amazon S3 Access Point. Customers can also access their entitled data using the S3 Access Point ARN.
     */
    public val s3AccessPointArn: kotlin.String? = builder.s3AccessPointArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dataexchange.model.S3DataAccessAsset = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3DataAccessAsset(")
        append("bucket=$bucket,")
        append("keyPrefixes=$keyPrefixes,")
        append("keys=$keys,")
        append("kmsKeysToGrant=$kmsKeysToGrant,")
        append("s3AccessPointAlias=$s3AccessPointAlias,")
        append("s3AccessPointArn=$s3AccessPointArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket.hashCode()
        result = 31 * result + (keyPrefixes?.hashCode() ?: 0)
        result = 31 * result + (keys?.hashCode() ?: 0)
        result = 31 * result + (kmsKeysToGrant?.hashCode() ?: 0)
        result = 31 * result + (s3AccessPointAlias?.hashCode() ?: 0)
        result = 31 * result + (s3AccessPointArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3DataAccessAsset

        if (bucket != other.bucket) return false
        if (keyPrefixes != other.keyPrefixes) return false
        if (keys != other.keys) return false
        if (kmsKeysToGrant != other.kmsKeysToGrant) return false
        if (s3AccessPointAlias != other.s3AccessPointAlias) return false
        if (s3AccessPointArn != other.s3AccessPointArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dataexchange.model.S3DataAccessAsset = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon S3 bucket hosting data to be shared in the S3 data access.
         */
        public var bucket: kotlin.String? = null
        /**
         * The Amazon S3 bucket used for hosting shared data in the Amazon S3 data access.
         */
        public var keyPrefixes: List<String>? = null
        /**
         * S3 keys made available using this asset.
         */
        public var keys: List<String>? = null
        /**
         * List of AWS KMS CMKs (Key Management System Customer Managed Keys) and ARNs used to encrypt S3 objects being shared in this S3 Data Access asset. Providers must include all AWS KMS keys used to encrypt these shared S3 objects.
         */
        public var kmsKeysToGrant: List<KmsKeyToGrant>? = null
        /**
         * The automatically-generated bucket-style alias for your Amazon S3 Access Point. Customers can access their entitled data using the S3 Access Point alias.
         */
        public var s3AccessPointAlias: kotlin.String? = null
        /**
         * The ARN for your Amazon S3 Access Point. Customers can also access their entitled data using the S3 Access Point ARN.
         */
        public var s3AccessPointArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dataexchange.model.S3DataAccessAsset) : this() {
            this.bucket = x.bucket
            this.keyPrefixes = x.keyPrefixes
            this.keys = x.keys
            this.kmsKeysToGrant = x.kmsKeysToGrant
            this.s3AccessPointAlias = x.s3AccessPointAlias
            this.s3AccessPointArn = x.s3AccessPointArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dataexchange.model.S3DataAccessAsset = S3DataAccessAsset(this)

        internal fun correctErrors(): Builder {
            if (bucket == null) bucket = ""
            return this
        }
    }
}
