// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dataexchange.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The Amazon Resource Name (ARN) of the AWS KMS key used to encrypt the shared S3 objects.
 */
public class KmsKeyToGrant private constructor(builder: Builder) {
    /**
     * The AWS KMS CMK (Key Management System Customer Managed Key) used to encrypt S3 objects in the shared S3 Bucket. AWS Data exchange will create a KMS grant for each subscriber to allow them to access and decrypt their entitled data that is encrypted using this KMS key specified.
     */
    public val kmsKeyArn: kotlin.String = requireNotNull(builder.kmsKeyArn) { "A non-null value must be provided for kmsKeyArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dataexchange.model.KmsKeyToGrant = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KmsKeyToGrant(")
        append("kmsKeyArn=$kmsKeyArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyArn.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KmsKeyToGrant

        if (kmsKeyArn != other.kmsKeyArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dataexchange.model.KmsKeyToGrant = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The AWS KMS CMK (Key Management System Customer Managed Key) used to encrypt S3 objects in the shared S3 Bucket. AWS Data exchange will create a KMS grant for each subscriber to allow them to access and decrypt their entitled data that is encrypted using this KMS key specified.
         */
        public var kmsKeyArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dataexchange.model.KmsKeyToGrant) : this() {
            this.kmsKeyArn = x.kmsKeyArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dataexchange.model.KmsKeyToGrant = KmsKeyToGrant(this)

        internal fun correctErrors(): Builder {
            if (kmsKeyArn == null) kmsKeyArn = ""
            return this
        }
    }
}
