// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dataexchange.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An error that occurred with the job request.
 */
public class JobError private constructor(builder: Builder) {
    /**
     * The code for the job error.
     */
    public val code: aws.sdk.kotlin.services.dataexchange.model.Code = requireNotNull(builder.code) { "A non-null value must be provided for code" }
    /**
     * The details about the job error.
     */
    public val details: aws.sdk.kotlin.services.dataexchange.model.Details? = builder.details
    /**
     * The name of the limit that was reached.
     */
    public val limitName: aws.sdk.kotlin.services.dataexchange.model.JobErrorLimitName? = builder.limitName
    /**
     * The value of the exceeded limit.
     */
    public val limitValue: kotlin.Double = builder.limitValue
    /**
     * The message related to the job error.
     */
    public val message: kotlin.String = requireNotNull(builder.message) { "A non-null value must be provided for message" }
    /**
     * The unique identifier for the resource related to the error.
     */
    public val resourceId: kotlin.String? = builder.resourceId
    /**
     * The type of resource related to the error.
     */
    public val resourceType: aws.sdk.kotlin.services.dataexchange.model.JobErrorResourceTypes? = builder.resourceType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dataexchange.model.JobError = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobError(")
        append("code=$code,")
        append("details=$details,")
        append("limitName=$limitName,")
        append("limitValue=$limitValue,")
        append("message=$message,")
        append("resourceId=$resourceId,")
        append("resourceType=$resourceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = code.hashCode()
        result = 31 * result + (details?.hashCode() ?: 0)
        result = 31 * result + (limitName?.hashCode() ?: 0)
        result = 31 * result + (limitValue.hashCode())
        result = 31 * result + (message.hashCode())
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobError

        if (code != other.code) return false
        if (details != other.details) return false
        if (limitName != other.limitName) return false
        if (limitValue != other.limitValue) return false
        if (message != other.message) return false
        if (resourceId != other.resourceId) return false
        if (resourceType != other.resourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dataexchange.model.JobError = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The code for the job error.
         */
        public var code: aws.sdk.kotlin.services.dataexchange.model.Code? = null
        /**
         * The details about the job error.
         */
        public var details: aws.sdk.kotlin.services.dataexchange.model.Details? = null
        /**
         * The name of the limit that was reached.
         */
        public var limitName: aws.sdk.kotlin.services.dataexchange.model.JobErrorLimitName? = null
        /**
         * The value of the exceeded limit.
         */
        public var limitValue: kotlin.Double = 0.0
        /**
         * The message related to the job error.
         */
        public var message: kotlin.String? = null
        /**
         * The unique identifier for the resource related to the error.
         */
        public var resourceId: kotlin.String? = null
        /**
         * The type of resource related to the error.
         */
        public var resourceType: aws.sdk.kotlin.services.dataexchange.model.JobErrorResourceTypes? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dataexchange.model.JobError) : this() {
            this.code = x.code
            this.details = x.details
            this.limitName = x.limitName
            this.limitValue = x.limitValue
            this.message = x.message
            this.resourceId = x.resourceId
            this.resourceType = x.resourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dataexchange.model.JobError = JobError(this)

        /**
         * construct an [aws.sdk.kotlin.services.dataexchange.model.Details] inside the given [block]
         */
        public fun details(block: aws.sdk.kotlin.services.dataexchange.model.Details.Builder.() -> kotlin.Unit) {
            this.details = aws.sdk.kotlin.services.dataexchange.model.Details.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (code == null) code = Code.SdkUnknown("no value provided")
            if (message == null) message = ""
            return this
        }
    }
}
