// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dataexchange.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The details in the response for an import request, including the signed URL and other information.
 */
public class ImportAssetFromSignedUrlResponseDetails private constructor(builder: Builder) {
    /**
     * The name for the asset associated with this import job.
     */
    public val assetName: kotlin.String = requireNotNull(builder.assetName) { "A non-null value must be provided for assetName" }
    /**
     * The unique identifier for the data set associated with this import job.
     */
    public val dataSetId: kotlin.String = requireNotNull(builder.dataSetId) { "A non-null value must be provided for dataSetId" }
    /**
     * The Base64-encoded Md5 hash for the asset, used to ensure the integrity of the file at that location.
     */
    public val md5Hash: kotlin.String? = builder.md5Hash
    /**
     * The unique identifier for the revision associated with this import response.
     */
    public val revisionId: kotlin.String = requireNotNull(builder.revisionId) { "A non-null value must be provided for revisionId" }
    /**
     * The signed URL.
     */
    public val signedUrl: kotlin.String? = builder.signedUrl
    /**
     * The time and date at which the signed URL expires, in ISO 8601 format.
     */
    public val signedUrlExpiresAt: aws.smithy.kotlin.runtime.time.Instant? = builder.signedUrlExpiresAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dataexchange.model.ImportAssetFromSignedUrlResponseDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImportAssetFromSignedUrlResponseDetails(")
        append("assetName=$assetName,")
        append("dataSetId=$dataSetId,")
        append("md5Hash=$md5Hash,")
        append("revisionId=$revisionId,")
        append("signedUrl=$signedUrl,")
        append("signedUrlExpiresAt=$signedUrlExpiresAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetName.hashCode()
        result = 31 * result + (dataSetId.hashCode())
        result = 31 * result + (md5Hash?.hashCode() ?: 0)
        result = 31 * result + (revisionId.hashCode())
        result = 31 * result + (signedUrl?.hashCode() ?: 0)
        result = 31 * result + (signedUrlExpiresAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImportAssetFromSignedUrlResponseDetails

        if (assetName != other.assetName) return false
        if (dataSetId != other.dataSetId) return false
        if (md5Hash != other.md5Hash) return false
        if (revisionId != other.revisionId) return false
        if (signedUrl != other.signedUrl) return false
        if (signedUrlExpiresAt != other.signedUrlExpiresAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dataexchange.model.ImportAssetFromSignedUrlResponseDetails = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name for the asset associated with this import job.
         */
        public var assetName: kotlin.String? = null
        /**
         * The unique identifier for the data set associated with this import job.
         */
        public var dataSetId: kotlin.String? = null
        /**
         * The Base64-encoded Md5 hash for the asset, used to ensure the integrity of the file at that location.
         */
        public var md5Hash: kotlin.String? = null
        /**
         * The unique identifier for the revision associated with this import response.
         */
        public var revisionId: kotlin.String? = null
        /**
         * The signed URL.
         */
        public var signedUrl: kotlin.String? = null
        /**
         * The time and date at which the signed URL expires, in ISO 8601 format.
         */
        public var signedUrlExpiresAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dataexchange.model.ImportAssetFromSignedUrlResponseDetails) : this() {
            this.assetName = x.assetName
            this.dataSetId = x.dataSetId
            this.md5Hash = x.md5Hash
            this.revisionId = x.revisionId
            this.signedUrl = x.signedUrl
            this.signedUrlExpiresAt = x.signedUrlExpiresAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dataexchange.model.ImportAssetFromSignedUrlResponseDetails = ImportAssetFromSignedUrlResponseDetails(this)

        internal fun correctErrors(): Builder {
            if (assetName == null) assetName = ""
            if (dataSetId == null) dataSetId = ""
            if (revisionId == null) revisionId = ""
            return this
        }
    }
}
