// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dataexchange.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Details about the export revisions to Amazon S3 response.
 */
public class ExportRevisionsToS3ResponseDetails private constructor(builder: Builder) {
    /**
     * The unique identifier for the data set associated with this export job.
     */
    public val dataSetId: kotlin.String = requireNotNull(builder.dataSetId) { "A non-null value must be provided for dataSetId" }
    /**
     * Encryption configuration of the export job.
     */
    public val encryption: aws.sdk.kotlin.services.dataexchange.model.ExportServerSideEncryption? = builder.encryption
    /**
     * The Amazon Resource Name (ARN) of the event action.
     */
    public val eventActionArn: kotlin.String? = builder.eventActionArn
    /**
     * The destination in Amazon S3 where the revision is exported.
     */
    public val revisionDestinations: List<RevisionDestinationEntry> = requireNotNull(builder.revisionDestinations) { "A non-null value must be provided for revisionDestinations" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dataexchange.model.ExportRevisionsToS3ResponseDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExportRevisionsToS3ResponseDetails(")
        append("dataSetId=$dataSetId,")
        append("encryption=$encryption,")
        append("eventActionArn=$eventActionArn,")
        append("revisionDestinations=$revisionDestinations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSetId.hashCode()
        result = 31 * result + (encryption?.hashCode() ?: 0)
        result = 31 * result + (eventActionArn?.hashCode() ?: 0)
        result = 31 * result + (revisionDestinations.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExportRevisionsToS3ResponseDetails

        if (dataSetId != other.dataSetId) return false
        if (encryption != other.encryption) return false
        if (eventActionArn != other.eventActionArn) return false
        if (revisionDestinations != other.revisionDestinations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dataexchange.model.ExportRevisionsToS3ResponseDetails = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique identifier for the data set associated with this export job.
         */
        public var dataSetId: kotlin.String? = null
        /**
         * Encryption configuration of the export job.
         */
        public var encryption: aws.sdk.kotlin.services.dataexchange.model.ExportServerSideEncryption? = null
        /**
         * The Amazon Resource Name (ARN) of the event action.
         */
        public var eventActionArn: kotlin.String? = null
        /**
         * The destination in Amazon S3 where the revision is exported.
         */
        public var revisionDestinations: List<RevisionDestinationEntry>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dataexchange.model.ExportRevisionsToS3ResponseDetails) : this() {
            this.dataSetId = x.dataSetId
            this.encryption = x.encryption
            this.eventActionArn = x.eventActionArn
            this.revisionDestinations = x.revisionDestinations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dataexchange.model.ExportRevisionsToS3ResponseDetails = ExportRevisionsToS3ResponseDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.dataexchange.model.ExportServerSideEncryption] inside the given [block]
         */
        public fun encryption(block: aws.sdk.kotlin.services.dataexchange.model.ExportServerSideEncryption.Builder.() -> kotlin.Unit) {
            this.encryption = aws.sdk.kotlin.services.dataexchange.model.ExportServerSideEncryption.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (dataSetId == null) dataSetId = ""
            if (revisionDestinations == null) revisionDestinations = emptyList()
            return this
        }
    }
}
