// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dataexchange.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A revision destination is the Amazon S3 bucket folder destination to where the export will be sent.
 */
public class AutoExportRevisionDestinationEntry private constructor(builder: Builder) {
    /**
     * The Amazon S3 bucket that is the destination for the event action.
     */
    public val bucket: kotlin.String = requireNotNull(builder.bucket) { "A non-null value must be provided for bucket" }
    /**
     * A string representing the pattern for generated names of the individual assets in the revision. For more information about key patterns, see [Key patterns when exporting revisions](https://docs.aws.amazon.com/data-exchange/latest/userguide/jobs.html#revision-export-keypatterns).
     */
    public val keyPattern: kotlin.String? = builder.keyPattern

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dataexchange.model.AutoExportRevisionDestinationEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoExportRevisionDestinationEntry(")
        append("bucket=$bucket,")
        append("keyPattern=$keyPattern")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket.hashCode()
        result = 31 * result + (keyPattern?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoExportRevisionDestinationEntry

        if (bucket != other.bucket) return false
        if (keyPattern != other.keyPattern) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dataexchange.model.AutoExportRevisionDestinationEntry = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon S3 bucket that is the destination for the event action.
         */
        public var bucket: kotlin.String? = null
        /**
         * A string representing the pattern for generated names of the individual assets in the revision. For more information about key patterns, see [Key patterns when exporting revisions](https://docs.aws.amazon.com/data-exchange/latest/userguide/jobs.html#revision-export-keypatterns).
         */
        public var keyPattern: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dataexchange.model.AutoExportRevisionDestinationEntry) : this() {
            this.bucket = x.bucket
            this.keyPattern = x.keyPattern
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dataexchange.model.AutoExportRevisionDestinationEntry = AutoExportRevisionDestinationEntry(this)

        internal fun correctErrors(): Builder {
            if (bucket == null) bucket = ""
            return this
        }
    }
}
