// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dataexchange.serde

import aws.sdk.kotlin.services.dataexchange.model.NotificationDetails
import aws.sdk.kotlin.services.dataexchange.model.NotificationType
import aws.sdk.kotlin.services.dataexchange.model.ScopeDetails
import aws.sdk.kotlin.services.dataexchange.model.SendDataSetNotificationRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class SendDataSetNotificationOperationSerializer: HttpSerialize<SendDataSetNotificationRequest> {
    override suspend fun serialize(context: ExecutionContext, input: SendDataSetNotificationRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.dataSetId) { "dataSetId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v1"))
                add(PercentEncoding.Path.encode("data-sets"))
                add(PercentEncoding.SmithyLabel.encode("${input.dataSetId}"))
                add(PercentEncoding.Path.encode("notification"))
            }
        }

        val payload = serializeSendDataSetNotificationOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeSendDataSetNotificationOperationBody(context: ExecutionContext, input: SendDataSetNotificationRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientToken"))
    val COMMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Comment"))
    val DETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Details"))
    val SCOPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Scope"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTTOKEN_DESCRIPTOR)
        field(COMMENT_DESCRIPTOR)
        field(DETAILS_DESCRIPTOR)
        field(SCOPE_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.comment?.let { field(COMMENT_DESCRIPTOR, it) }
        input.details?.let { field(DETAILS_DESCRIPTOR, it, ::serializeNotificationDetailsDocument) }
        input.scope?.let { field(SCOPE_DESCRIPTOR, it, ::serializeScopeDetailsDocument) }
        input.type?.let { field(TYPE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
