// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dataexchange.serde

import aws.sdk.kotlin.services.dataexchange.model.DataExchangeException
import aws.sdk.kotlin.services.dataexchange.model.SendApiAssetResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class SendApiAssetOperationDeserializer: HttpDeserialize<SendApiAssetResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): SendApiAssetResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwSendApiAssetError(context, call)
        }
        val builder = SendApiAssetResponse.Builder()

        val keysForResponseHeaders = response.headers.names()
        if (keysForResponseHeaders.isNotEmpty()) {
            val map = mutableMapOf<String, String>()
            for (hdrKey in keysForResponseHeaders) {
                val el = response.headers[hdrKey] ?: continue
                map[hdrKey] = el
            }
            builder.responseHeaders = map
        } else {
            builder.responseHeaders = emptyMap()
        }

        val contents = response.body.readAll()?.decodeToString()
        builder.body = contents

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwSendApiAssetError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DataExchangeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        else -> DataExchangeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
