// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dataexchange.serde

import aws.sdk.kotlin.services.dataexchange.model.Action
import aws.sdk.kotlin.services.dataexchange.model.DataExchangeException
import aws.sdk.kotlin.services.dataexchange.model.Event
import aws.sdk.kotlin.services.dataexchange.model.GetEventActionResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetEventActionOperationDeserializer: HttpDeserialize<GetEventActionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetEventActionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetEventActionError(context, call)
        }
        val builder = GetEventActionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetEventActionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetEventActionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DataExchangeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        else -> DataExchangeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetEventActionOperationBody(builder: GetEventActionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Action"))
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedAt"))
    val EVENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Event"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Id"))
    val UPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("UpdatedAt"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTION_DESCRIPTOR)
        field(ARN_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(EVENT_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(UPDATEDAT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACTION_DESCRIPTOR.index -> builder.action = deserializeActionDocument(deserializer)
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromIso8601(it) }
                EVENT_DESCRIPTOR.index -> builder.event = deserializeEventDocument(deserializer)
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                UPDATEDAT_DESCRIPTOR.index -> builder.updatedAt = deserializeString().let { Instant.fromIso8601(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
