// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dataexchange.model



/**
 * Source details for an Amazon S3 data access asset.
 */
public class S3DataAccessAssetSourceEntry private constructor(builder: Builder) {
    /**
     * The Amazon S3 bucket used for hosting shared data in the Amazon S3 data access.
     */
    public val bucket: kotlin.String = requireNotNull(builder.bucket) { "A non-null value must be provided for bucket" }
    /**
     * Organizes Amazon S3 asset key prefixes stored in an Amazon S3 bucket.
     */
    public val keyPrefixes: List<String>? = builder.keyPrefixes
    /**
     * The keys used to create the Amazon S3 data access.
     */
    public val keys: List<String>? = builder.keys
    /**
     * List of AWS KMS CMKs (Key Management System Customer Managed Keys) and ARNs used to encrypt S3 objects being shared in this S3 Data Access asset.
     */
    public val kmsKeysToGrant: List<KmsKeyToGrant>? = builder.kmsKeysToGrant

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dataexchange.model.S3DataAccessAssetSourceEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3DataAccessAssetSourceEntry(")
        append("bucket=$bucket,")
        append("keyPrefixes=$keyPrefixes,")
        append("keys=$keys,")
        append("kmsKeysToGrant=$kmsKeysToGrant")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket.hashCode()
        result = 31 * result + (keyPrefixes?.hashCode() ?: 0)
        result = 31 * result + (keys?.hashCode() ?: 0)
        result = 31 * result + (kmsKeysToGrant?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3DataAccessAssetSourceEntry

        if (bucket != other.bucket) return false
        if (keyPrefixes != other.keyPrefixes) return false
        if (keys != other.keys) return false
        if (kmsKeysToGrant != other.kmsKeysToGrant) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dataexchange.model.S3DataAccessAssetSourceEntry = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon S3 bucket used for hosting shared data in the Amazon S3 data access.
         */
        public var bucket: kotlin.String? = null
        /**
         * Organizes Amazon S3 asset key prefixes stored in an Amazon S3 bucket.
         */
        public var keyPrefixes: List<String>? = null
        /**
         * The keys used to create the Amazon S3 data access.
         */
        public var keys: List<String>? = null
        /**
         * List of AWS KMS CMKs (Key Management System Customer Managed Keys) and ARNs used to encrypt S3 objects being shared in this S3 Data Access asset.
         */
        public var kmsKeysToGrant: List<KmsKeyToGrant>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dataexchange.model.S3DataAccessAssetSourceEntry) : this() {
            this.bucket = x.bucket
            this.keyPrefixes = x.keyPrefixes
            this.keys = x.keys
            this.kmsKeysToGrant = x.kmsKeysToGrant
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dataexchange.model.S3DataAccessAssetSourceEntry = S3DataAccessAssetSourceEntry(this)

        internal fun correctErrors(): Builder {
            if (bucket == null) bucket = ""
            return this
        }
    }
}
