// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dataexchange.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The details of the export to signed URL response.
 */
public class ExportAssetToSignedUrlResponseDetails private constructor(builder: Builder) {
    /**
     * The unique identifier for the asset associated with this export job.
     */
    public val assetId: kotlin.String = requireNotNull(builder.assetId) { "A non-null value must be provided for assetId" }
    /**
     * The unique identifier for the data set associated with this export job.
     */
    public val dataSetId: kotlin.String = requireNotNull(builder.dataSetId) { "A non-null value must be provided for dataSetId" }
    /**
     * The unique identifier for the revision associated with this export response.
     */
    public val revisionId: kotlin.String = requireNotNull(builder.revisionId) { "A non-null value must be provided for revisionId" }
    /**
     * The signed URL for the export request.
     */
    public val signedUrl: kotlin.String? = builder.signedUrl
    /**
     * The date and time that the signed URL expires, in ISO 8601 format.
     */
    public val signedUrlExpiresAt: aws.smithy.kotlin.runtime.time.Instant? = builder.signedUrlExpiresAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dataexchange.model.ExportAssetToSignedUrlResponseDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExportAssetToSignedUrlResponseDetails(")
        append("assetId=$assetId,")
        append("dataSetId=$dataSetId,")
        append("revisionId=$revisionId,")
        append("signedUrl=$signedUrl,")
        append("signedUrlExpiresAt=$signedUrlExpiresAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetId.hashCode()
        result = 31 * result + (dataSetId.hashCode())
        result = 31 * result + (revisionId.hashCode())
        result = 31 * result + (signedUrl?.hashCode() ?: 0)
        result = 31 * result + (signedUrlExpiresAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExportAssetToSignedUrlResponseDetails

        if (assetId != other.assetId) return false
        if (dataSetId != other.dataSetId) return false
        if (revisionId != other.revisionId) return false
        if (signedUrl != other.signedUrl) return false
        if (signedUrlExpiresAt != other.signedUrlExpiresAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dataexchange.model.ExportAssetToSignedUrlResponseDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier for the asset associated with this export job.
         */
        public var assetId: kotlin.String? = null
        /**
         * The unique identifier for the data set associated with this export job.
         */
        public var dataSetId: kotlin.String? = null
        /**
         * The unique identifier for the revision associated with this export response.
         */
        public var revisionId: kotlin.String? = null
        /**
         * The signed URL for the export request.
         */
        public var signedUrl: kotlin.String? = null
        /**
         * The date and time that the signed URL expires, in ISO 8601 format.
         */
        public var signedUrlExpiresAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dataexchange.model.ExportAssetToSignedUrlResponseDetails) : this() {
            this.assetId = x.assetId
            this.dataSetId = x.dataSetId
            this.revisionId = x.revisionId
            this.signedUrl = x.signedUrl
            this.signedUrlExpiresAt = x.signedUrlExpiresAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dataexchange.model.ExportAssetToSignedUrlResponseDetails = ExportAssetToSignedUrlResponseDetails(this)

        internal fun correctErrors(): Builder {
            if (assetId == null) assetId = ""
            if (dataSetId == null) dataSetId = ""
            if (revisionId == null) revisionId = ""
            return this
        }
    }
}
