// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dataexchange.model



/**
 * The destination for the asset.
 */
public class AssetDestinationEntry private constructor(builder: Builder) {
    /**
     * The unique identifier for the asset.
     */
    public val assetId: kotlin.String = requireNotNull(builder.assetId) { "A non-null value must be provided for assetId" }
    /**
     * The Amazon S3 bucket that is the destination for the asset.
     */
    public val bucket: kotlin.String = requireNotNull(builder.bucket) { "A non-null value must be provided for bucket" }
    /**
     * The name of the object in Amazon S3 for the asset.
     */
    public val key: kotlin.String? = builder.key

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dataexchange.model.AssetDestinationEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssetDestinationEntry(")
        append("assetId=$assetId,")
        append("bucket=$bucket,")
        append("key=$key")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetId.hashCode()
        result = 31 * result + (bucket.hashCode())
        result = 31 * result + (key?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssetDestinationEntry

        if (assetId != other.assetId) return false
        if (bucket != other.bucket) return false
        if (key != other.key) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dataexchange.model.AssetDestinationEntry = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier for the asset.
         */
        public var assetId: kotlin.String? = null
        /**
         * The Amazon S3 bucket that is the destination for the asset.
         */
        public var bucket: kotlin.String? = null
        /**
         * The name of the object in Amazon S3 for the asset.
         */
        public var key: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dataexchange.model.AssetDestinationEntry) : this() {
            this.assetId = x.assetId
            this.bucket = x.bucket
            this.key = x.key
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dataexchange.model.AssetDestinationEntry = AssetDestinationEntry(this)

        internal fun correctErrors(): Builder {
            if (assetId == null) assetId = ""
            if (bucket == null) bucket = ""
            return this
        }
    }
}
