// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dataexchange

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.dataexchange.auth.DataExchangeAuthSchemeProvider
import aws.sdk.kotlin.services.dataexchange.auth.DefaultDataExchangeAuthSchemeProvider
import aws.sdk.kotlin.services.dataexchange.endpoints.DataExchangeEndpointParameters
import aws.sdk.kotlin.services.dataexchange.endpoints.DataExchangeEndpointProvider
import aws.sdk.kotlin.services.dataexchange.endpoints.DefaultDataExchangeEndpointProvider
import aws.sdk.kotlin.services.dataexchange.model.CancelJobRequest
import aws.sdk.kotlin.services.dataexchange.model.CancelJobResponse
import aws.sdk.kotlin.services.dataexchange.model.CreateDataSetRequest
import aws.sdk.kotlin.services.dataexchange.model.CreateDataSetResponse
import aws.sdk.kotlin.services.dataexchange.model.CreateEventActionRequest
import aws.sdk.kotlin.services.dataexchange.model.CreateEventActionResponse
import aws.sdk.kotlin.services.dataexchange.model.CreateJobRequest
import aws.sdk.kotlin.services.dataexchange.model.CreateJobResponse
import aws.sdk.kotlin.services.dataexchange.model.CreateRevisionRequest
import aws.sdk.kotlin.services.dataexchange.model.CreateRevisionResponse
import aws.sdk.kotlin.services.dataexchange.model.DeleteAssetRequest
import aws.sdk.kotlin.services.dataexchange.model.DeleteAssetResponse
import aws.sdk.kotlin.services.dataexchange.model.DeleteDataSetRequest
import aws.sdk.kotlin.services.dataexchange.model.DeleteDataSetResponse
import aws.sdk.kotlin.services.dataexchange.model.DeleteEventActionRequest
import aws.sdk.kotlin.services.dataexchange.model.DeleteEventActionResponse
import aws.sdk.kotlin.services.dataexchange.model.DeleteRevisionRequest
import aws.sdk.kotlin.services.dataexchange.model.DeleteRevisionResponse
import aws.sdk.kotlin.services.dataexchange.model.GetAssetRequest
import aws.sdk.kotlin.services.dataexchange.model.GetAssetResponse
import aws.sdk.kotlin.services.dataexchange.model.GetDataSetRequest
import aws.sdk.kotlin.services.dataexchange.model.GetDataSetResponse
import aws.sdk.kotlin.services.dataexchange.model.GetEventActionRequest
import aws.sdk.kotlin.services.dataexchange.model.GetEventActionResponse
import aws.sdk.kotlin.services.dataexchange.model.GetJobRequest
import aws.sdk.kotlin.services.dataexchange.model.GetJobResponse
import aws.sdk.kotlin.services.dataexchange.model.GetRevisionRequest
import aws.sdk.kotlin.services.dataexchange.model.GetRevisionResponse
import aws.sdk.kotlin.services.dataexchange.model.ListDataSetRevisionsRequest
import aws.sdk.kotlin.services.dataexchange.model.ListDataSetRevisionsResponse
import aws.sdk.kotlin.services.dataexchange.model.ListDataSetsRequest
import aws.sdk.kotlin.services.dataexchange.model.ListDataSetsResponse
import aws.sdk.kotlin.services.dataexchange.model.ListEventActionsRequest
import aws.sdk.kotlin.services.dataexchange.model.ListEventActionsResponse
import aws.sdk.kotlin.services.dataexchange.model.ListJobsRequest
import aws.sdk.kotlin.services.dataexchange.model.ListJobsResponse
import aws.sdk.kotlin.services.dataexchange.model.ListRevisionAssetsRequest
import aws.sdk.kotlin.services.dataexchange.model.ListRevisionAssetsResponse
import aws.sdk.kotlin.services.dataexchange.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.dataexchange.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.dataexchange.model.RevokeRevisionRequest
import aws.sdk.kotlin.services.dataexchange.model.RevokeRevisionResponse
import aws.sdk.kotlin.services.dataexchange.model.SendApiAssetRequest
import aws.sdk.kotlin.services.dataexchange.model.SendApiAssetResponse
import aws.sdk.kotlin.services.dataexchange.model.SendDataSetNotificationRequest
import aws.sdk.kotlin.services.dataexchange.model.SendDataSetNotificationResponse
import aws.sdk.kotlin.services.dataexchange.model.StartJobRequest
import aws.sdk.kotlin.services.dataexchange.model.StartJobResponse
import aws.sdk.kotlin.services.dataexchange.model.TagResourceRequest
import aws.sdk.kotlin.services.dataexchange.model.TagResourceResponse
import aws.sdk.kotlin.services.dataexchange.model.UntagResourceRequest
import aws.sdk.kotlin.services.dataexchange.model.UntagResourceResponse
import aws.sdk.kotlin.services.dataexchange.model.UpdateAssetRequest
import aws.sdk.kotlin.services.dataexchange.model.UpdateAssetResponse
import aws.sdk.kotlin.services.dataexchange.model.UpdateDataSetRequest
import aws.sdk.kotlin.services.dataexchange.model.UpdateDataSetResponse
import aws.sdk.kotlin.services.dataexchange.model.UpdateEventActionRequest
import aws.sdk.kotlin.services.dataexchange.model.UpdateEventActionResponse
import aws.sdk.kotlin.services.dataexchange.model.UpdateRevisionRequest
import aws.sdk.kotlin.services.dataexchange.model.UpdateRevisionResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "DataExchange"
public const val SdkVersion: String = "1.0.10"

/**
 * AWS Data Exchange is a service that makes it easy for AWS customers to exchange data in the cloud. You can use the AWS Data Exchange APIs to create, update, manage, and access file-based data set in the AWS Cloud.
 *
 * As a subscriber, you can view and access the data sets that you have an entitlement to through a subscription. You can use the APIs to download or copy your entitled data sets to Amazon Simple Storage Service (Amazon S3) for use across a variety of AWS analytics and machine learning services.
 *
 * As a provider, you can create and manage your data sets that you would like to publish to a product. Being able to package and provide your data sets into products requires a few steps to determine eligibility. For more information, visit the *AWS Data Exchange User Guide*.
 *
 * A data set is a collection of data that can be changed or updated over time. Data sets can be updated using revisions, which represent a new version or incremental change to a data set. A revision contains one or more assets. An asset in AWS Data Exchange is a piece of data that can be stored as an Amazon S3 object, Redshift datashare, API Gateway API, AWS Lake Formation data permission, or Amazon S3 data access. The asset can be a structured data file, an image file, or some other data file. Jobs are asynchronous import or export operations used to create or copy assets.
 */
public interface DataExchangeClient : SdkClient {
    /**
     * DataExchangeClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, DataExchangeClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "DataExchange",
                "DATAEXCHANGE",
                "dataexchange",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, DataExchangeClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): DataExchangeClient = DefaultDataExchangeClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: DataExchangeEndpointProvider = builder.endpointProvider ?: DefaultDataExchangeEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: DataExchangeAuthSchemeProvider = builder.authSchemeProvider ?: DefaultDataExchangeAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "DataExchange"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: DataExchangeEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: DataExchangeAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * This operation cancels a job. Jobs can be cancelled only when they are in the WAITING state.
     */
    public suspend fun cancelJob(input: CancelJobRequest): CancelJobResponse

    /**
     * This operation creates a data set.
     */
    public suspend fun createDataSet(input: CreateDataSetRequest): CreateDataSetResponse

    /**
     * This operation creates an event action.
     */
    public suspend fun createEventAction(input: CreateEventActionRequest): CreateEventActionResponse

    /**
     * This operation creates a job.
     */
    public suspend fun createJob(input: CreateJobRequest): CreateJobResponse

    /**
     * This operation creates a revision for a data set.
     */
    public suspend fun createRevision(input: CreateRevisionRequest): CreateRevisionResponse

    /**
     * This operation deletes an asset.
     */
    public suspend fun deleteAsset(input: DeleteAssetRequest): DeleteAssetResponse

    /**
     * This operation deletes a data set.
     */
    public suspend fun deleteDataSet(input: DeleteDataSetRequest): DeleteDataSetResponse

    /**
     * This operation deletes the event action.
     */
    public suspend fun deleteEventAction(input: DeleteEventActionRequest): DeleteEventActionResponse

    /**
     * This operation deletes a revision.
     */
    public suspend fun deleteRevision(input: DeleteRevisionRequest): DeleteRevisionResponse

    /**
     * This operation returns information about an asset.
     */
    public suspend fun getAsset(input: GetAssetRequest): GetAssetResponse

    /**
     * This operation returns information about a data set.
     */
    public suspend fun getDataSet(input: GetDataSetRequest): GetDataSetResponse

    /**
     * This operation retrieves information about an event action.
     */
    public suspend fun getEventAction(input: GetEventActionRequest): GetEventActionResponse

    /**
     * This operation returns information about a job.
     */
    public suspend fun getJob(input: GetJobRequest): GetJobResponse

    /**
     * This operation returns information about a revision.
     */
    public suspend fun getRevision(input: GetRevisionRequest): GetRevisionResponse

    /**
     * This operation lists a data set's revisions sorted by CreatedAt in descending order.
     */
    public suspend fun listDataSetRevisions(input: ListDataSetRevisionsRequest): ListDataSetRevisionsResponse

    /**
     * This operation lists your data sets. When listing by origin OWNED, results are sorted by CreatedAt in descending order. When listing by origin ENTITLED, there is no order and the maxResults parameter is ignored.
     */
    public suspend fun listDataSets(input: ListDataSetsRequest = ListDataSetsRequest { }): ListDataSetsResponse

    /**
     * This operation lists your event actions.
     */
    public suspend fun listEventActions(input: ListEventActionsRequest = ListEventActionsRequest { }): ListEventActionsResponse

    /**
     * This operation lists your jobs sorted by CreatedAt in descending order.
     */
    public suspend fun listJobs(input: ListJobsRequest = ListJobsRequest { }): ListJobsResponse

    /**
     * This operation lists a revision's assets sorted alphabetically in descending order.
     */
    public suspend fun listRevisionAssets(input: ListRevisionAssetsRequest): ListRevisionAssetsResponse

    /**
     * This operation lists the tags on the resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * This operation revokes subscribers' access to a revision.
     */
    public suspend fun revokeRevision(input: RevokeRevisionRequest): RevokeRevisionResponse

    /**
     * This operation invokes an API Gateway API asset. The request is proxied to the provider’s API Gateway API.
     */
    public suspend fun sendApiAsset(input: SendApiAssetRequest): SendApiAssetResponse

    /**
     * The type of event associated with the data set.
     */
    public suspend fun sendDataSetNotification(input: SendDataSetNotificationRequest): SendDataSetNotificationResponse

    /**
     * This operation starts a job.
     */
    public suspend fun startJob(input: StartJobRequest): StartJobResponse

    /**
     * This operation tags a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * This operation removes one or more tags from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * This operation updates an asset.
     */
    public suspend fun updateAsset(input: UpdateAssetRequest): UpdateAssetResponse

    /**
     * This operation updates a data set.
     */
    public suspend fun updateDataSet(input: UpdateDataSetRequest): UpdateDataSetResponse

    /**
     * This operation updates the event action.
     */
    public suspend fun updateEventAction(input: UpdateEventActionRequest): UpdateEventActionResponse

    /**
     * This operation updates a revision.
     */
    public suspend fun updateRevision(input: UpdateRevisionRequest): UpdateRevisionResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun DataExchangeClient.withConfig(block: DataExchangeClient.Config.Builder.() -> Unit): DataExchangeClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultDataExchangeClient(newConfig)
}

/**
 * This operation cancels a job. Jobs can be cancelled only when they are in the WAITING state.
 */
public suspend inline fun DataExchangeClient.cancelJob(crossinline block: CancelJobRequest.Builder.() -> Unit): CancelJobResponse = cancelJob(CancelJobRequest.Builder().apply(block).build())

/**
 * This operation creates a data set.
 */
public suspend inline fun DataExchangeClient.createDataSet(crossinline block: CreateDataSetRequest.Builder.() -> Unit): CreateDataSetResponse = createDataSet(CreateDataSetRequest.Builder().apply(block).build())

/**
 * This operation creates an event action.
 */
public suspend inline fun DataExchangeClient.createEventAction(crossinline block: CreateEventActionRequest.Builder.() -> Unit): CreateEventActionResponse = createEventAction(CreateEventActionRequest.Builder().apply(block).build())

/**
 * This operation creates a job.
 */
public suspend inline fun DataExchangeClient.createJob(crossinline block: CreateJobRequest.Builder.() -> Unit): CreateJobResponse = createJob(CreateJobRequest.Builder().apply(block).build())

/**
 * This operation creates a revision for a data set.
 */
public suspend inline fun DataExchangeClient.createRevision(crossinline block: CreateRevisionRequest.Builder.() -> Unit): CreateRevisionResponse = createRevision(CreateRevisionRequest.Builder().apply(block).build())

/**
 * This operation deletes an asset.
 */
public suspend inline fun DataExchangeClient.deleteAsset(crossinline block: DeleteAssetRequest.Builder.() -> Unit): DeleteAssetResponse = deleteAsset(DeleteAssetRequest.Builder().apply(block).build())

/**
 * This operation deletes a data set.
 */
public suspend inline fun DataExchangeClient.deleteDataSet(crossinline block: DeleteDataSetRequest.Builder.() -> Unit): DeleteDataSetResponse = deleteDataSet(DeleteDataSetRequest.Builder().apply(block).build())

/**
 * This operation deletes the event action.
 */
public suspend inline fun DataExchangeClient.deleteEventAction(crossinline block: DeleteEventActionRequest.Builder.() -> Unit): DeleteEventActionResponse = deleteEventAction(DeleteEventActionRequest.Builder().apply(block).build())

/**
 * This operation deletes a revision.
 */
public suspend inline fun DataExchangeClient.deleteRevision(crossinline block: DeleteRevisionRequest.Builder.() -> Unit): DeleteRevisionResponse = deleteRevision(DeleteRevisionRequest.Builder().apply(block).build())

/**
 * This operation returns information about an asset.
 */
public suspend inline fun DataExchangeClient.getAsset(crossinline block: GetAssetRequest.Builder.() -> Unit): GetAssetResponse = getAsset(GetAssetRequest.Builder().apply(block).build())

/**
 * This operation returns information about a data set.
 */
public suspend inline fun DataExchangeClient.getDataSet(crossinline block: GetDataSetRequest.Builder.() -> Unit): GetDataSetResponse = getDataSet(GetDataSetRequest.Builder().apply(block).build())

/**
 * This operation retrieves information about an event action.
 */
public suspend inline fun DataExchangeClient.getEventAction(crossinline block: GetEventActionRequest.Builder.() -> Unit): GetEventActionResponse = getEventAction(GetEventActionRequest.Builder().apply(block).build())

/**
 * This operation returns information about a job.
 */
public suspend inline fun DataExchangeClient.getJob(crossinline block: GetJobRequest.Builder.() -> Unit): GetJobResponse = getJob(GetJobRequest.Builder().apply(block).build())

/**
 * This operation returns information about a revision.
 */
public suspend inline fun DataExchangeClient.getRevision(crossinline block: GetRevisionRequest.Builder.() -> Unit): GetRevisionResponse = getRevision(GetRevisionRequest.Builder().apply(block).build())

/**
 * This operation lists a data set's revisions sorted by CreatedAt in descending order.
 */
public suspend inline fun DataExchangeClient.listDataSetRevisions(crossinline block: ListDataSetRevisionsRequest.Builder.() -> Unit): ListDataSetRevisionsResponse = listDataSetRevisions(ListDataSetRevisionsRequest.Builder().apply(block).build())

/**
 * This operation lists your data sets. When listing by origin OWNED, results are sorted by CreatedAt in descending order. When listing by origin ENTITLED, there is no order and the maxResults parameter is ignored.
 */
public suspend inline fun DataExchangeClient.listDataSets(crossinline block: ListDataSetsRequest.Builder.() -> Unit): ListDataSetsResponse = listDataSets(ListDataSetsRequest.Builder().apply(block).build())

/**
 * This operation lists your event actions.
 */
public suspend inline fun DataExchangeClient.listEventActions(crossinline block: ListEventActionsRequest.Builder.() -> Unit): ListEventActionsResponse = listEventActions(ListEventActionsRequest.Builder().apply(block).build())

/**
 * This operation lists your jobs sorted by CreatedAt in descending order.
 */
public suspend inline fun DataExchangeClient.listJobs(crossinline block: ListJobsRequest.Builder.() -> Unit): ListJobsResponse = listJobs(ListJobsRequest.Builder().apply(block).build())

/**
 * This operation lists a revision's assets sorted alphabetically in descending order.
 */
public suspend inline fun DataExchangeClient.listRevisionAssets(crossinline block: ListRevisionAssetsRequest.Builder.() -> Unit): ListRevisionAssetsResponse = listRevisionAssets(ListRevisionAssetsRequest.Builder().apply(block).build())

/**
 * This operation lists the tags on the resource.
 */
public suspend inline fun DataExchangeClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * This operation revokes subscribers' access to a revision.
 */
public suspend inline fun DataExchangeClient.revokeRevision(crossinline block: RevokeRevisionRequest.Builder.() -> Unit): RevokeRevisionResponse = revokeRevision(RevokeRevisionRequest.Builder().apply(block).build())

/**
 * This operation invokes an API Gateway API asset. The request is proxied to the provider’s API Gateway API.
 */
public suspend inline fun DataExchangeClient.sendApiAsset(crossinline block: SendApiAssetRequest.Builder.() -> Unit): SendApiAssetResponse = sendApiAsset(SendApiAssetRequest.Builder().apply(block).build())

/**
 * The type of event associated with the data set.
 */
public suspend inline fun DataExchangeClient.sendDataSetNotification(crossinline block: SendDataSetNotificationRequest.Builder.() -> Unit): SendDataSetNotificationResponse = sendDataSetNotification(SendDataSetNotificationRequest.Builder().apply(block).build())

/**
 * This operation starts a job.
 */
public suspend inline fun DataExchangeClient.startJob(crossinline block: StartJobRequest.Builder.() -> Unit): StartJobResponse = startJob(StartJobRequest.Builder().apply(block).build())

/**
 * This operation tags a resource.
 */
public suspend inline fun DataExchangeClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * This operation removes one or more tags from a resource.
 */
public suspend inline fun DataExchangeClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * This operation updates an asset.
 */
public suspend inline fun DataExchangeClient.updateAsset(crossinline block: UpdateAssetRequest.Builder.() -> Unit): UpdateAssetResponse = updateAsset(UpdateAssetRequest.Builder().apply(block).build())

/**
 * This operation updates a data set.
 */
public suspend inline fun DataExchangeClient.updateDataSet(crossinline block: UpdateDataSetRequest.Builder.() -> Unit): UpdateDataSetResponse = updateDataSet(UpdateDataSetRequest.Builder().apply(block).build())

/**
 * This operation updates the event action.
 */
public suspend inline fun DataExchangeClient.updateEventAction(crossinline block: UpdateEventActionRequest.Builder.() -> Unit): UpdateEventActionResponse = updateEventAction(UpdateEventActionRequest.Builder().apply(block).build())

/**
 * This operation updates a revision.
 */
public suspend inline fun DataExchangeClient.updateRevision(crossinline block: UpdateRevisionRequest.Builder.() -> Unit): UpdateRevisionResponse = updateRevision(UpdateRevisionRequest.Builder().apply(block).build())
