// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dataexchange.transform

import aws.sdk.kotlin.services.dataexchange.model.SendApiAssetRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.net.parameters
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import kotlin.text.encodeToByteArray


internal class SendApiAssetOperationSerializer: HttpSerialize<SendApiAssetRequest> {
    override suspend fun serialize(context: ExecutionContext, input: SendApiAssetRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/v1"
            parameters {
                input.queryStringParameters
                    ?.filterNot{ contains(it.key) }
                    ?.forEach { (key, value) ->
                        append(key, value)
                    }
            }
        }

        builder.headers {
            if (input.assetId?.isNotEmpty() == true) append("x-amzn-dataexchange-asset-id", input.assetId)
            if (input.dataSetId?.isNotEmpty() == true) append("x-amzn-dataexchange-data-set-id", input.dataSetId)
            if (input.method?.isNotEmpty() == true) append("x-amzn-dataexchange-http-method", input.method)
            if (input.path?.isNotEmpty() == true) append("x-amzn-dataexchange-path", input.path)
            if (input.revisionId?.isNotEmpty() == true) append("x-amzn-dataexchange-revision-id", input.revisionId)
            input.requestHeaders?.filter { it.value != null }?.forEach { (key, value) ->
                append("x-amzn-dataexchange-header-$key", value!!)
            }
        }

        if (input.body != null) {
            builder.body = ByteArrayContent(input.body.encodeToByteArray())
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "text/plain")
        }
        if (input.body == null) {
            builder.headers.setMissing("Content-Type", "text/plain")
        }
        return builder
    }
}
