// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dataexchange.model



/**
 * The destination where the assets in the revision will be exported.
 */
public class RevisionDestinationEntry private constructor(builder: Builder) {
    /**
     * The Amazon S3 bucket that is the destination for the assets in the revision.
     */
    public val bucket: kotlin.String? = builder.bucket
    /**
     * A string representing the pattern for generated names of the individual assets in the revision. For more information about key patterns, see [Key patterns when exporting revisions](https://docs.aws.amazon.com/data-exchange/latest/userguide/jobs.html#revision-export-keypatterns).
     */
    public val keyPattern: kotlin.String? = builder.keyPattern
    /**
     * The unique identifier for the revision.
     */
    public val revisionId: kotlin.String? = builder.revisionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dataexchange.model.RevisionDestinationEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RevisionDestinationEntry(")
        append("bucket=$bucket,")
        append("keyPattern=$keyPattern,")
        append("revisionId=$revisionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (keyPattern?.hashCode() ?: 0)
        result = 31 * result + (revisionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RevisionDestinationEntry

        if (bucket != other.bucket) return false
        if (keyPattern != other.keyPattern) return false
        if (revisionId != other.revisionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dataexchange.model.RevisionDestinationEntry = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon S3 bucket that is the destination for the assets in the revision.
         */
        public var bucket: kotlin.String? = null
        /**
         * A string representing the pattern for generated names of the individual assets in the revision. For more information about key patterns, see [Key patterns when exporting revisions](https://docs.aws.amazon.com/data-exchange/latest/userguide/jobs.html#revision-export-keypatterns).
         */
        public var keyPattern: kotlin.String? = null
        /**
         * The unique identifier for the revision.
         */
        public var revisionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dataexchange.model.RevisionDestinationEntry) : this() {
            this.bucket = x.bucket
            this.keyPattern = x.keyPattern
            this.revisionId = x.revisionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dataexchange.model.RevisionDestinationEntry = RevisionDestinationEntry(this)
    }
}
