// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dataexchange.model



/**
 * Encryption configuration of the export job. Includes the encryption type in addition to the AWS KMS key. The KMS key is only necessary if you chose the KMS encryption type.
 */
public class ExportServerSideEncryption private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the AWS KMS key you want to use to encrypt the Amazon S3 objects. This parameter is required if you choose aws:kms as an encryption type.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * The type of server side encryption used for encrypting the objects in Amazon S3.
     */
    public val type: aws.sdk.kotlin.services.dataexchange.model.ServerSideEncryptionTypes? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dataexchange.model.ExportServerSideEncryption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExportServerSideEncryption(")
        append("kmsKeyArn=$kmsKeyArn,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyArn?.hashCode() ?: 0
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExportServerSideEncryption

        if (kmsKeyArn != other.kmsKeyArn) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dataexchange.model.ExportServerSideEncryption = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the AWS KMS key you want to use to encrypt the Amazon S3 objects. This parameter is required if you choose aws:kms as an encryption type.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * The type of server side encryption used for encrypting the objects in Amazon S3.
         */
        public var type: aws.sdk.kotlin.services.dataexchange.model.ServerSideEncryptionTypes? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dataexchange.model.ExportServerSideEncryption) : this() {
            this.kmsKeyArn = x.kmsKeyArn
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dataexchange.model.ExportServerSideEncryption = ExportServerSideEncryption(this)
    }
}
