// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dataexchange.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An asset in AWS Data Exchange is a piece of data (Amazon S3 object) or a means of fulfilling data (Amazon Redshift datashare or Amazon API Gateway API, AWS Lake Formation data permission, or Amazon S3 data access). The asset can be a structured data file, an image file, or some other data file that can be stored as an Amazon S3 object, an Amazon API Gateway API, or an Amazon Redshift datashare, an AWS Lake Formation data permission, or an Amazon S3 data access. When you create an import job for your files, API Gateway APIs, Amazon Redshift datashares, AWS Lake Formation data permission, or Amazon S3 data access, you create an asset in AWS Data Exchange.
 */
public class AssetEntry private constructor(builder: Builder) {
    /**
     * The ARN for the asset.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * Details about the asset.
     */
    public val assetDetails: aws.sdk.kotlin.services.dataexchange.model.AssetDetails? = builder.assetDetails
    /**
     * The type of asset that is added to a data set.
     */
    public val assetType: aws.sdk.kotlin.services.dataexchange.model.AssetType? = builder.assetType
    /**
     * The date and time that the asset was created, in ISO 8601 format.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The unique identifier for the data set associated with this asset.
     */
    public val dataSetId: kotlin.String? = builder.dataSetId
    /**
     * The unique identifier for the asset.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The name of the asset. When importing from Amazon S3, the Amazon S3 object key is used as the asset name. When exporting to Amazon S3, the asset name is used as default target Amazon S3 object key. When importing from Amazon API Gateway API, the API name is used as the asset name. When importing from Amazon Redshift, the datashare name is used as the asset name. When importing from AWS Lake Formation, the static values of "Database(s) included in LF-tag policy" or "Table(s) included in LF-tag policy" are used as the asset name.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The unique identifier for the revision associated with this asset.
     */
    public val revisionId: kotlin.String? = builder.revisionId
    /**
     * The asset ID of the owned asset corresponding to the entitled asset being viewed. This parameter is returned when an asset owner is viewing the entitled copy of its owned asset.
     */
    public val sourceId: kotlin.String? = builder.sourceId
    /**
     * The date and time that the asset was last updated, in ISO 8601 format.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dataexchange.model.AssetEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssetEntry(")
        append("arn=$arn,")
        append("assetDetails=$assetDetails,")
        append("assetType=$assetType,")
        append("createdAt=$createdAt,")
        append("dataSetId=$dataSetId,")
        append("id=$id,")
        append("name=$name,")
        append("revisionId=$revisionId,")
        append("sourceId=$sourceId,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (assetDetails?.hashCode() ?: 0)
        result = 31 * result + (assetType?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (dataSetId?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (revisionId?.hashCode() ?: 0)
        result = 31 * result + (sourceId?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssetEntry

        if (arn != other.arn) return false
        if (assetDetails != other.assetDetails) return false
        if (assetType != other.assetType) return false
        if (createdAt != other.createdAt) return false
        if (dataSetId != other.dataSetId) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (revisionId != other.revisionId) return false
        if (sourceId != other.sourceId) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dataexchange.model.AssetEntry = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN for the asset.
         */
        public var arn: kotlin.String? = null
        /**
         * Details about the asset.
         */
        public var assetDetails: aws.sdk.kotlin.services.dataexchange.model.AssetDetails? = null
        /**
         * The type of asset that is added to a data set.
         */
        public var assetType: aws.sdk.kotlin.services.dataexchange.model.AssetType? = null
        /**
         * The date and time that the asset was created, in ISO 8601 format.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique identifier for the data set associated with this asset.
         */
        public var dataSetId: kotlin.String? = null
        /**
         * The unique identifier for the asset.
         */
        public var id: kotlin.String? = null
        /**
         * The name of the asset. When importing from Amazon S3, the Amazon S3 object key is used as the asset name. When exporting to Amazon S3, the asset name is used as default target Amazon S3 object key. When importing from Amazon API Gateway API, the API name is used as the asset name. When importing from Amazon Redshift, the datashare name is used as the asset name. When importing from AWS Lake Formation, the static values of "Database(s) included in LF-tag policy" or "Table(s) included in LF-tag policy" are used as the asset name.
         */
        public var name: kotlin.String? = null
        /**
         * The unique identifier for the revision associated with this asset.
         */
        public var revisionId: kotlin.String? = null
        /**
         * The asset ID of the owned asset corresponding to the entitled asset being viewed. This parameter is returned when an asset owner is viewing the entitled copy of its owned asset.
         */
        public var sourceId: kotlin.String? = null
        /**
         * The date and time that the asset was last updated, in ISO 8601 format.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dataexchange.model.AssetEntry) : this() {
            this.arn = x.arn
            this.assetDetails = x.assetDetails
            this.assetType = x.assetType
            this.createdAt = x.createdAt
            this.dataSetId = x.dataSetId
            this.id = x.id
            this.name = x.name
            this.revisionId = x.revisionId
            this.sourceId = x.sourceId
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dataexchange.model.AssetEntry = AssetEntry(this)

        /**
         * construct an [aws.sdk.kotlin.services.dataexchange.model.AssetDetails] inside the given [block]
         */
        public fun assetDetails(block: aws.sdk.kotlin.services.dataexchange.model.AssetDetails.Builder.() -> kotlin.Unit) {
            this.assetDetails = aws.sdk.kotlin.services.dataexchange.model.AssetDetails.invoke(block)
        }
    }
}
