// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * In response to a request by the DescribeReplicationTasks operation, this object provides
 * a collection of statistics about a replication task.
 */
class ReplicationTaskStats private constructor(builder: Builder) {
    /**
     * The elapsed time of the task, in milliseconds.
     */
    val elapsedTimeMillis: kotlin.Long = builder.elapsedTimeMillis
    /**
     * The date the replication task was started either with a fresh start or a target reload.
     */
    val freshStartDate: aws.smithy.kotlin.runtime.time.Instant? = builder.freshStartDate
    /**
     * The date the replication task full load was completed.
     */
    val fullLoadFinishDate: aws.smithy.kotlin.runtime.time.Instant? = builder.fullLoadFinishDate
    /**
     * The percent complete for the full load migration task.
     */
    val fullLoadProgressPercent: kotlin.Int = builder.fullLoadProgressPercent
    /**
     * The date the replication task full load was started.
     */
    val fullLoadStartDate: aws.smithy.kotlin.runtime.time.Instant? = builder.fullLoadStartDate
    /**
     * The date the replication task was started either with a fresh start or a resume. For more information, see
     * <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html#DMS-StartReplicationTask-request-StartReplicationTaskType">StartReplicationTaskType.
     */
    val startDate: aws.smithy.kotlin.runtime.time.Instant? = builder.startDate
    /**
     * The date the replication task was stopped.
     */
    val stopDate: aws.smithy.kotlin.runtime.time.Instant? = builder.stopDate
    /**
     * The number of errors that have occurred during this task.
     */
    val tablesErrored: kotlin.Int = builder.tablesErrored
    /**
     * The number of tables loaded for this task.
     */
    val tablesLoaded: kotlin.Int = builder.tablesLoaded
    /**
     * The number of tables currently loading for this task.
     */
    val tablesLoading: kotlin.Int = builder.tablesLoading
    /**
     * The number of tables queued for this task.
     */
    val tablesQueued: kotlin.Int = builder.tablesQueued

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationTaskStats = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReplicationTaskStats(")
        append("elapsedTimeMillis=$elapsedTimeMillis,")
        append("freshStartDate=$freshStartDate,")
        append("fullLoadFinishDate=$fullLoadFinishDate,")
        append("fullLoadProgressPercent=$fullLoadProgressPercent,")
        append("fullLoadStartDate=$fullLoadStartDate,")
        append("startDate=$startDate,")
        append("stopDate=$stopDate,")
        append("tablesErrored=$tablesErrored,")
        append("tablesLoaded=$tablesLoaded,")
        append("tablesLoading=$tablesLoading,")
        append("tablesQueued=$tablesQueued)")
    }

    override fun hashCode(): kotlin.Int {
        var result = elapsedTimeMillis.hashCode()
        result = 31 * result + (freshStartDate?.hashCode() ?: 0)
        result = 31 * result + (fullLoadFinishDate?.hashCode() ?: 0)
        result = 31 * result + (fullLoadProgressPercent)
        result = 31 * result + (fullLoadStartDate?.hashCode() ?: 0)
        result = 31 * result + (startDate?.hashCode() ?: 0)
        result = 31 * result + (stopDate?.hashCode() ?: 0)
        result = 31 * result + (tablesErrored)
        result = 31 * result + (tablesLoaded)
        result = 31 * result + (tablesLoading)
        result = 31 * result + (tablesQueued)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ReplicationTaskStats

        if (elapsedTimeMillis != other.elapsedTimeMillis) return false
        if (freshStartDate != other.freshStartDate) return false
        if (fullLoadFinishDate != other.fullLoadFinishDate) return false
        if (fullLoadProgressPercent != other.fullLoadProgressPercent) return false
        if (fullLoadStartDate != other.fullLoadStartDate) return false
        if (startDate != other.startDate) return false
        if (stopDate != other.stopDate) return false
        if (tablesErrored != other.tablesErrored) return false
        if (tablesLoaded != other.tablesLoaded) return false
        if (tablesLoading != other.tablesLoading) return false
        if (tablesQueued != other.tablesQueued) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationTaskStats = Builder(this).apply(block).build()

    class Builder {
        /**
         * The elapsed time of the task, in milliseconds.
         */
        var elapsedTimeMillis: kotlin.Long = 0L
        /**
         * The date the replication task was started either with a fresh start or a target reload.
         */
        var freshStartDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date the replication task full load was completed.
         */
        var fullLoadFinishDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The percent complete for the full load migration task.
         */
        var fullLoadProgressPercent: kotlin.Int = 0
        /**
         * The date the replication task full load was started.
         */
        var fullLoadStartDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date the replication task was started either with a fresh start or a resume. For more information, see
         * <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html#DMS-StartReplicationTask-request-StartReplicationTaskType">StartReplicationTaskType.
         */
        var startDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date the replication task was stopped.
         */
        var stopDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of errors that have occurred during this task.
         */
        var tablesErrored: kotlin.Int = 0
        /**
         * The number of tables loaded for this task.
         */
        var tablesLoaded: kotlin.Int = 0
        /**
         * The number of tables currently loading for this task.
         */
        var tablesLoading: kotlin.Int = 0
        /**
         * The number of tables queued for this task.
         */
        var tablesQueued: kotlin.Int = 0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationTaskStats) : this() {
            this.elapsedTimeMillis = x.elapsedTimeMillis
            this.freshStartDate = x.freshStartDate
            this.fullLoadFinishDate = x.fullLoadFinishDate
            this.fullLoadProgressPercent = x.fullLoadProgressPercent
            this.fullLoadStartDate = x.fullLoadStartDate
            this.startDate = x.startDate
            this.stopDate = x.stopDate
            this.tablesErrored = x.tablesErrored
            this.tablesLoaded = x.tablesLoaded
            this.tablesLoading = x.tablesLoading
            this.tablesQueued = x.tablesQueued
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationTaskStats = ReplicationTaskStats(this)
    }
}
