// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information that describes a premigration assessment run that you have started
 * using the StartReplicationTaskAssessmentRun operation.
 * Some of the information appears based on other operations that can return the
 * ReplicationTaskAssessmentRun object.
 */
class ReplicationTaskAssessmentRun private constructor(builder: Builder) {
    /**
     * Indication of the completion progress for the individual assessments specified to
     * run.
     */
    val assessmentProgress: aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationTaskAssessmentRunProgress? = builder.assessmentProgress
    /**
     * Unique name of the assessment run.
     */
    val assessmentRunName: kotlin.String? = builder.assessmentRunName
    /**
     * Last message generated by an individual assessment failure.
     */
    val lastFailureMessage: kotlin.String? = builder.lastFailureMessage
    /**
     * ARN of the migration task associated with this premigration
     * assessment run.
     */
    val replicationTaskArn: kotlin.String? = builder.replicationTaskArn
    /**
     * Amazon Resource Name (ARN) of this assessment run.
     */
    val replicationTaskAssessmentRunArn: kotlin.String? = builder.replicationTaskAssessmentRunArn
    /**
     * Date on which the assessment run was created using the
     * StartReplicationTaskAssessmentRun operation.
     */
    val replicationTaskAssessmentRunCreationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.replicationTaskAssessmentRunCreationDate
    /**
     * Encryption mode used to encrypt the assessment run results.
     */
    val resultEncryptionMode: kotlin.String? = builder.resultEncryptionMode
    /**
     * ARN of the KMS encryption key used to encrypt the assessment run results.
     */
    val resultKmsKeyArn: kotlin.String? = builder.resultKmsKeyArn
    /**
     * Amazon S3 bucket where DMS stores the results of this assessment run.
     */
    val resultLocationBucket: kotlin.String? = builder.resultLocationBucket
    /**
     * Folder in an Amazon S3 bucket where DMS stores the results of this assessment
     * run.
     */
    val resultLocationFolder: kotlin.String? = builder.resultLocationFolder
    /**
     * ARN of the service role used to start the assessment run using the
     * StartReplicationTaskAssessmentRun operation. The role must allow the iam:PassRole action.
     */
    val serviceAccessRoleArn: kotlin.String? = builder.serviceAccessRoleArn
    /**
     * Assessment run status.
     * This status can have one of the following values:
     * "cancelling" – The assessment run was canceled by the
     * CancelReplicationTaskAssessmentRun operation.
     * "deleting" – The assessment run was deleted by the
     * DeleteReplicationTaskAssessmentRun operation.
     * "failed" – At least one individual assessment completed with a
     * failed status.
     * "error-provisioning" – An internal error occurred while
     * resources were provisioned (during provisioning status).
     * "error-executing" – An internal error occurred while
     * individual assessments ran (during running status).
     * "invalid state" – The assessment run is in an unknown state.
     * "passed" – All individual assessments have completed, and none
     * has a failed status.
     * "provisioning" – Resources required to run individual
     * assessments are being provisioned.
     * "running" – Individual assessments are being run.
     * "starting" – The assessment run is starting, but resources are not yet
     * being provisioned for individual assessments.
     */
    val status: kotlin.String? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationTaskAssessmentRun = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReplicationTaskAssessmentRun(")
        append("assessmentProgress=$assessmentProgress,")
        append("assessmentRunName=$assessmentRunName,")
        append("lastFailureMessage=$lastFailureMessage,")
        append("replicationTaskArn=$replicationTaskArn,")
        append("replicationTaskAssessmentRunArn=$replicationTaskAssessmentRunArn,")
        append("replicationTaskAssessmentRunCreationDate=$replicationTaskAssessmentRunCreationDate,")
        append("resultEncryptionMode=$resultEncryptionMode,")
        append("resultKmsKeyArn=$resultKmsKeyArn,")
        append("resultLocationBucket=$resultLocationBucket,")
        append("resultLocationFolder=$resultLocationFolder,")
        append("serviceAccessRoleArn=$serviceAccessRoleArn,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assessmentProgress?.hashCode() ?: 0
        result = 31 * result + (assessmentRunName?.hashCode() ?: 0)
        result = 31 * result + (lastFailureMessage?.hashCode() ?: 0)
        result = 31 * result + (replicationTaskArn?.hashCode() ?: 0)
        result = 31 * result + (replicationTaskAssessmentRunArn?.hashCode() ?: 0)
        result = 31 * result + (replicationTaskAssessmentRunCreationDate?.hashCode() ?: 0)
        result = 31 * result + (resultEncryptionMode?.hashCode() ?: 0)
        result = 31 * result + (resultKmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (resultLocationBucket?.hashCode() ?: 0)
        result = 31 * result + (resultLocationFolder?.hashCode() ?: 0)
        result = 31 * result + (serviceAccessRoleArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ReplicationTaskAssessmentRun

        if (assessmentProgress != other.assessmentProgress) return false
        if (assessmentRunName != other.assessmentRunName) return false
        if (lastFailureMessage != other.lastFailureMessage) return false
        if (replicationTaskArn != other.replicationTaskArn) return false
        if (replicationTaskAssessmentRunArn != other.replicationTaskAssessmentRunArn) return false
        if (replicationTaskAssessmentRunCreationDate != other.replicationTaskAssessmentRunCreationDate) return false
        if (resultEncryptionMode != other.resultEncryptionMode) return false
        if (resultKmsKeyArn != other.resultKmsKeyArn) return false
        if (resultLocationBucket != other.resultLocationBucket) return false
        if (resultLocationFolder != other.resultLocationFolder) return false
        if (serviceAccessRoleArn != other.serviceAccessRoleArn) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationTaskAssessmentRun = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indication of the completion progress for the individual assessments specified to
         * run.
         */
        var assessmentProgress: aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationTaskAssessmentRunProgress? = null
        /**
         * Unique name of the assessment run.
         */
        var assessmentRunName: kotlin.String? = null
        /**
         * Last message generated by an individual assessment failure.
         */
        var lastFailureMessage: kotlin.String? = null
        /**
         * ARN of the migration task associated with this premigration
         * assessment run.
         */
        var replicationTaskArn: kotlin.String? = null
        /**
         * Amazon Resource Name (ARN) of this assessment run.
         */
        var replicationTaskAssessmentRunArn: kotlin.String? = null
        /**
         * Date on which the assessment run was created using the
         * StartReplicationTaskAssessmentRun operation.
         */
        var replicationTaskAssessmentRunCreationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Encryption mode used to encrypt the assessment run results.
         */
        var resultEncryptionMode: kotlin.String? = null
        /**
         * ARN of the KMS encryption key used to encrypt the assessment run results.
         */
        var resultKmsKeyArn: kotlin.String? = null
        /**
         * Amazon S3 bucket where DMS stores the results of this assessment run.
         */
        var resultLocationBucket: kotlin.String? = null
        /**
         * Folder in an Amazon S3 bucket where DMS stores the results of this assessment
         * run.
         */
        var resultLocationFolder: kotlin.String? = null
        /**
         * ARN of the service role used to start the assessment run using the
         * StartReplicationTaskAssessmentRun operation. The role must allow the iam:PassRole action.
         */
        var serviceAccessRoleArn: kotlin.String? = null
        /**
         * Assessment run status.
         * This status can have one of the following values:
         * "cancelling" – The assessment run was canceled by the
         * CancelReplicationTaskAssessmentRun operation.
         * "deleting" – The assessment run was deleted by the
         * DeleteReplicationTaskAssessmentRun operation.
         * "failed" – At least one individual assessment completed with a
         * failed status.
         * "error-provisioning" – An internal error occurred while
         * resources were provisioned (during provisioning status).
         * "error-executing" – An internal error occurred while
         * individual assessments ran (during running status).
         * "invalid state" – The assessment run is in an unknown state.
         * "passed" – All individual assessments have completed, and none
         * has a failed status.
         * "provisioning" – Resources required to run individual
         * assessments are being provisioned.
         * "running" – Individual assessments are being run.
         * "starting" – The assessment run is starting, but resources are not yet
         * being provisioned for individual assessments.
         */
        var status: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationTaskAssessmentRun) : this() {
            this.assessmentProgress = x.assessmentProgress
            this.assessmentRunName = x.assessmentRunName
            this.lastFailureMessage = x.lastFailureMessage
            this.replicationTaskArn = x.replicationTaskArn
            this.replicationTaskAssessmentRunArn = x.replicationTaskAssessmentRunArn
            this.replicationTaskAssessmentRunCreationDate = x.replicationTaskAssessmentRunCreationDate
            this.resultEncryptionMode = x.resultEncryptionMode
            this.resultKmsKeyArn = x.resultKmsKeyArn
            this.resultLocationBucket = x.resultLocationBucket
            this.resultLocationFolder = x.resultLocationFolder
            this.serviceAccessRoleArn = x.serviceAccessRoleArn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationTaskAssessmentRun = ReplicationTaskAssessmentRun(this)

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationTaskAssessmentRunProgress] inside the given [block]
         */
        fun assessmentProgress(block: aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationTaskAssessmentRunProgress.Builder.() -> kotlin.Unit) {
            this.assessmentProgress = aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationTaskAssessmentRunProgress.invoke(block)
        }
    }
}
